/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.exceptions;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.exceptions.BraintreeError;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorWithResponse
extends Exception
implements Parcelable {
    private static final String ERROR_KEY = "error";
    private static final String MESSAGE_KEY = "message";
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private int mStatusCode;
    private String mMessage;
    private String mOriginalResponse;
    private List<BraintreeError> mFieldErrors;
    public static final Parcelable.Creator<ErrorWithResponse> CREATOR = new Parcelable.Creator<ErrorWithResponse>(){

        public ErrorWithResponse createFromParcel(Parcel source) {
            return new ErrorWithResponse(source);
        }

        public ErrorWithResponse[] newArray(int size) {
            return new ErrorWithResponse[size];
        }
    };

    public ErrorWithResponse(int statusCode, String jsonString) {
        this.mStatusCode = statusCode;
        this.mOriginalResponse = jsonString;
        try {
            this.parseJson(jsonString);
        }
        catch (JSONException e) {
            this.mMessage = "Parsing error response failed";
            this.mFieldErrors = new ArrayList<BraintreeError>();
        }
    }

    private ErrorWithResponse() {
    }

    public static ErrorWithResponse fromJson(String json) throws JSONException {
        ErrorWithResponse errorWithResponse = new ErrorWithResponse();
        errorWithResponse.mOriginalResponse = json;
        errorWithResponse.parseJson(json);
        return errorWithResponse;
    }

    public static ErrorWithResponse fromGraphQLJson(String json) {
        ErrorWithResponse errorWithResponse = new ErrorWithResponse();
        errorWithResponse.mOriginalResponse = json;
        errorWithResponse.mStatusCode = 422;
        try {
            JSONArray errors = new JSONObject(json).getJSONArray("errors");
            errorWithResponse.mFieldErrors = BraintreeError.fromGraphQLJsonArray(errors);
            errorWithResponse.mMessage = errorWithResponse.mFieldErrors.isEmpty() ? errors.getJSONObject(0).getString(MESSAGE_KEY) : "Input is invalid.";
        }
        catch (JSONException e) {
            errorWithResponse.mMessage = "Parsing error response failed";
            errorWithResponse.mFieldErrors = new ArrayList<BraintreeError>();
        }
        return errorWithResponse;
    }

    private void parseJson(String jsonString) throws JSONException {
        JSONObject json = new JSONObject(jsonString);
        this.mMessage = json.getJSONObject(ERROR_KEY).getString(MESSAGE_KEY);
        this.mFieldErrors = BraintreeError.fromJsonArray(json.optJSONArray(FIELD_ERRORS_KEY));
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    public String getErrorResponse() {
        return this.mOriginalResponse;
    }

    public List<BraintreeError> getFieldErrors() {
        return this.mFieldErrors;
    }

    @Nullable
    public BraintreeError errorFor(String field) {
        if (this.mFieldErrors != null) {
            for (BraintreeError error : this.mFieldErrors) {
                BraintreeError returnError;
                if (error.getField().equals(field)) {
                    return error;
                }
                if (error.getFieldErrors() == null || (returnError = error.errorFor(field)) == null) continue;
                return returnError;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "ErrorWithResponse (" + this.mStatusCode + "): " + this.mMessage + "\n" + this.mFieldErrors.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatusCode);
        dest.writeString(this.mMessage);
        dest.writeString(this.mOriginalResponse);
        dest.writeTypedList(this.mFieldErrors);
    }

    protected ErrorWithResponse(Parcel in) {
        this.mStatusCode = in.readInt();
        this.mMessage = in.readString();
        this.mOriginalResponse = in.readString();
        this.mFieldErrors = in.createTypedArrayList(BraintreeError.CREATOR);
    }
}

