/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.exceptions;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BraintreeError
implements Parcelable {
    private static final String FIELD_KEY = "field";
    private static final String MESSAGE_KEY = "message";
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private String mField;
    private String mMessage;
    private List<BraintreeError> mFieldErrors;
    public static final Parcelable.Creator<BraintreeError> CREATOR = new Parcelable.Creator<BraintreeError>(){

        public BraintreeError createFromParcel(Parcel source) {
            return new BraintreeError(source);
        }

        public BraintreeError[] newArray(int size) {
            return new BraintreeError[size];
        }
    };

    public static List<BraintreeError> fromJsonArray(JSONArray json) {
        if (json == null) {
            json = new JSONArray();
        }
        ArrayList<BraintreeError> errors = new ArrayList<BraintreeError>();
        for (int i = 0; i < json.length(); ++i) {
            try {
                errors.add(BraintreeError.fromJson(json.getJSONObject(i)));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return errors;
    }

    protected static List<BraintreeError> fromGraphQLJsonArray(JSONArray graphQLErrors) {
        ArrayList<BraintreeError> errors = new ArrayList<BraintreeError>();
        if (graphQLErrors == null) {
            return errors;
        }
        for (int i = 0; i < graphQLErrors.length(); ++i) {
            try {
                JSONObject graphQLError = graphQLErrors.getJSONObject(i);
                JSONObject extensions = graphQLError.optJSONObject("extensions");
                if (extensions == null || !"user_error".equals(extensions.optString("errorType"))) continue;
                ArrayList<String> inputPath = new ArrayList<String>();
                JSONArray inputPathJSON = extensions.getJSONArray("inputPath");
                for (int j = 1; j < inputPathJSON.length(); ++j) {
                    inputPath.add(inputPathJSON.getString(j));
                }
                BraintreeError.addGraphQLFieldError(inputPath, graphQLError, errors);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return errors;
    }

    public static BraintreeError fromJson(JSONObject json) {
        BraintreeError error = new BraintreeError();
        error.mField = Json.optString((JSONObject)json, (String)FIELD_KEY, null);
        error.mMessage = Json.optString((JSONObject)json, (String)MESSAGE_KEY, null);
        error.mFieldErrors = BraintreeError.fromJsonArray(json.optJSONArray(FIELD_ERRORS_KEY));
        return error;
    }

    private static void addGraphQLFieldError(List<String> inputPath, JSONObject errorJSON, List<BraintreeError> errors) throws JSONException {
        String field = inputPath.get(0);
        if (inputPath.size() == 1) {
            BraintreeError error = new BraintreeError();
            error.mField = field;
            error.mMessage = errorJSON.getString(MESSAGE_KEY);
            error.mFieldErrors = new ArrayList<BraintreeError>();
            errors.add(error);
            return;
        }
        BraintreeError nestedError = null;
        List<String> nestedInputPath = inputPath.subList(1, inputPath.size());
        for (BraintreeError error : errors) {
            if (!error.mField.equals(field)) continue;
            nestedError = error;
        }
        if (nestedError == null) {
            nestedError = new BraintreeError();
            nestedError.mField = field;
            nestedError.mFieldErrors = new ArrayList<BraintreeError>();
            errors.add(nestedError);
        }
        BraintreeError.addGraphQLFieldError(nestedInputPath, errorJSON, nestedError.mFieldErrors);
    }

    @Nullable
    public String getMessage() {
        return this.mMessage;
    }

    public String getField() {
        return this.mField;
    }

    public List<BraintreeError> getFieldErrors() {
        return this.mFieldErrors;
    }

    @Nullable
    public BraintreeError errorFor(String field) {
        if (this.mFieldErrors != null) {
            for (BraintreeError error : this.mFieldErrors) {
                BraintreeError returnError;
                if (error.getField().equals(field)) {
                    return error;
                }
                if (error.getFieldErrors() == null || (returnError = error.errorFor(field)) == null) continue;
                return returnError;
            }
        }
        return null;
    }

    public String toString() {
        return "BraintreeError for " + this.mField + ": " + this.mMessage + " -> " + (this.mFieldErrors != null ? this.mFieldErrors.toString() : "");
    }

    public BraintreeError() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mField);
        dest.writeString(this.mMessage);
        dest.writeTypedList(this.mFieldErrors);
    }

    protected BraintreeError(Parcel in) {
        this.mField = in.readString();
        this.mMessage = in.readString();
        this.mFieldErrors = in.createTypedArrayList(CREATOR);
    }
}

