/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.exceptions;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.exceptions.BraintreeApiError;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BraintreeApiErrorResponse
extends Exception
implements Parcelable {
    private String mMessage;
    private String mOriginalResponse;
    private List<BraintreeApiError> mErrors;
    public static final Parcelable.Creator<BraintreeApiErrorResponse> CREATOR = new Parcelable.Creator<BraintreeApiErrorResponse>(){

        public BraintreeApiErrorResponse createFromParcel(Parcel source) {
            return new BraintreeApiErrorResponse(source);
        }

        public BraintreeApiErrorResponse[] newArray(int size) {
            return new BraintreeApiErrorResponse[size];
        }
    };

    public BraintreeApiErrorResponse(String jsonString) {
        this.mOriginalResponse = jsonString;
        try {
            JSONObject json = new JSONObject(jsonString);
            JSONObject error = json.getJSONObject("error");
            this.mMessage = Json.optString((JSONObject)error, (String)"developer_message", (String)"No message was returned");
            this.mErrors = BraintreeApiError.fromJsonArray(error.optJSONArray("details"));
        }
        catch (JSONException e) {
            this.mMessage = "Parsing error response failed";
        }
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    public String getErrorResponse() {
        return this.mOriginalResponse;
    }

    @Nullable
    public List<BraintreeApiError> getErrors() {
        return this.mErrors;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mMessage);
        dest.writeString(this.mOriginalResponse);
        dest.writeTypedList(this.mErrors);
    }

    protected BraintreeApiErrorResponse(Parcel in) {
        this.mMessage = in.readString();
        this.mOriginalResponse = in.readString();
        this.mErrors = in.createTypedArrayList(BraintreeApiError.CREATOR);
    }
}

