/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.net.Uri;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.exceptions.ConfigurationException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.UnionPayCapabilities;
import com.braintreepayments.api.models.UnionPayCardBuilder;
import com.braintreepayments.api.models.UnionPayConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public class UnionPay {
    private static final String UNIONPAY_ENROLLMENT_ID_KEY = "unionPayEnrollmentId";
    private static final String UNIONPAY_SMS_REQUIRED_KEY = "smsCodeRequired";
    private static final String UNIONPAY_CAPABILITIES_PATH = TokenizationClient.versionedPath("payment_methods/credit_cards/capabilities");
    private static final String UNIONPAY_ENROLLMENT_PATH = TokenizationClient.versionedPath("union_pay_enrollments");

    public static void fetchCapabilities(final BraintreeFragment fragment, final String cardNumber) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (!configuration.getUnionPay().isEnabled()) {
                    fragment.postCallback(new ConfigurationException("UnionPay is not enabled"));
                    return;
                }
                String fetchCapabilitiesUrl = Uri.parse((String)UNIONPAY_CAPABILITIES_PATH).buildUpon().appendQueryParameter("creditCard[number]", cardNumber).build().toString();
                fragment.getHttpClient().get(fetchCapabilitiesUrl, new HttpResponseCallback(){

                    public void success(String responseBody) {
                        fragment.postCallback(UnionPayCapabilities.fromJson(responseBody));
                        fragment.sendAnalyticsEvent("union-pay.capabilities-received");
                    }

                    public void failure(Exception exception) {
                        fragment.postCallback(exception);
                        fragment.sendAnalyticsEvent("union-pay.capabilities-failed");
                    }
                });
            }
        });
    }

    public static void enroll(final BraintreeFragment fragment, final UnionPayCardBuilder unionPayCardBuilder) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                UnionPayConfiguration unionPayConfiguration = configuration.getUnionPay();
                if (!unionPayConfiguration.isEnabled()) {
                    fragment.postCallback(new ConfigurationException("UnionPay is not enabled"));
                    return;
                }
                try {
                    JSONObject enrollmentPayloadJson = unionPayCardBuilder.buildEnrollment();
                    fragment.getHttpClient().post(UNIONPAY_ENROLLMENT_PATH, enrollmentPayloadJson.toString(), new HttpResponseCallback(){

                        public void success(String responseBody) {
                            try {
                                JSONObject response = new JSONObject(responseBody);
                                String enrollmentId = response.getString(UnionPay.UNIONPAY_ENROLLMENT_ID_KEY);
                                boolean smsCodeRequired = response.getBoolean(UnionPay.UNIONPAY_SMS_REQUIRED_KEY);
                                fragment.postUnionPayCallback(enrollmentId, smsCodeRequired);
                                fragment.sendAnalyticsEvent("union-pay.enrollment-succeeded");
                            }
                            catch (JSONException e) {
                                this.failure((Exception)((Object)e));
                            }
                        }

                        public void failure(Exception exception) {
                            fragment.postCallback(exception);
                            fragment.sendAnalyticsEvent("union-pay.enrollment-failed");
                        }
                    });
                }
                catch (JSONException exception) {
                    fragment.postCallback((Exception)((Object)exception));
                }
            }
        });
    }

    public static void tokenize(final BraintreeFragment fragment, UnionPayCardBuilder unionPayCardBuilder) {
        TokenizationClient.tokenize(fragment, unionPayCardBuilder, new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                fragment.postCallback(paymentMethodNonce);
                fragment.sendAnalyticsEvent("union-pay.nonce-received");
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
                fragment.sendAnalyticsEvent("union-pay.nonce-failed");
            }
        });
    }
}

