/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.models.CardBuilder;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodBuilder;
import com.braintreepayments.api.models.PaymentMethodNonce;
import org.json.JSONException;

class TokenizationClient {
    static final String PAYMENT_METHOD_ENDPOINT = "payment_methods";

    TokenizationClient() {
    }

    static void tokenize(final BraintreeFragment fragment, final PaymentMethodBuilder paymentMethodBuilder, final PaymentMethodNonceCallback callback) {
        paymentMethodBuilder.setSessionId(fragment.getSessionId());
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (paymentMethodBuilder instanceof CardBuilder && configuration.getGraphQL().isFeatureEnabled("tokenize_credit_cards")) {
                    TokenizationClient.tokenizeGraphQL(fragment, (CardBuilder)paymentMethodBuilder, callback);
                } else {
                    TokenizationClient.tokenizeRest(fragment, paymentMethodBuilder, callback);
                }
            }
        });
    }

    static String versionedPath(String path) {
        return "/v1/" + path;
    }

    private static void tokenizeGraphQL(final BraintreeFragment fragment, final CardBuilder cardBuilder, final PaymentMethodNonceCallback callback) {
        String payload;
        fragment.sendAnalyticsEvent("card.graphql.tokenization.started");
        try {
            payload = cardBuilder.buildGraphQL(fragment.getApplicationContext(), fragment.getAuthorization());
        }
        catch (BraintreeException e) {
            callback.failure(e);
            return;
        }
        fragment.getGraphQLHttpClient().post(payload, new HttpResponseCallback(){

            public void success(String responseBody) {
                try {
                    callback.success(PaymentMethodNonce.parsePaymentMethodNonces(responseBody, cardBuilder.getResponsePaymentMethodType()));
                    fragment.sendAnalyticsEvent("card.graphql.tokenization.success");
                }
                catch (JSONException e) {
                    callback.failure((Exception)((Object)e));
                }
            }

            public void failure(Exception exception) {
                fragment.sendAnalyticsEvent("card.graphql.tokenization.failure");
                callback.failure(exception);
            }
        });
    }

    private static void tokenizeRest(BraintreeFragment fragment, final PaymentMethodBuilder paymentMethodBuilder, final PaymentMethodNonceCallback callback) {
        fragment.getHttpClient().post(TokenizationClient.versionedPath("payment_methods/" + paymentMethodBuilder.getApiPath()), paymentMethodBuilder.build(), new HttpResponseCallback(){

            public void success(String responseBody) {
                try {
                    callback.success(PaymentMethodNonce.parsePaymentMethodNonces(responseBody, paymentMethodBuilder.getResponsePaymentMethodType()));
                }
                catch (JSONException e) {
                    callback.failure((Exception)((Object)e));
                }
            }

            public void failure(Exception exception) {
                callback.failure(exception);
            }
        });
    }
}

