/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.braintreepayments.api.BraintreeBrowserSwitchActivity;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.ThreeDSecureActivity;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.interfaces.ThreeDSecureLookupListener;
import com.braintreepayments.api.interfaces.ThreeDSecurePrepareLookupListener;
import com.braintreepayments.api.internal.ManifestValidator;
import com.braintreepayments.api.internal.ThreeDSecureV1BrowserSwitchHelper;
import com.braintreepayments.api.models.CardBuilder;
import com.braintreepayments.api.models.CardNonce;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.ThreeDSecureAuthenticationResponse;
import com.braintreepayments.api.models.ThreeDSecureInfo;
import com.braintreepayments.api.models.ThreeDSecureLookup;
import com.braintreepayments.api.models.ThreeDSecureRequest;
import com.cardinalcommerce.cardinalmobilesdk.Cardinal;
import com.cardinalcommerce.cardinalmobilesdk.enums.CardinalEnvironment;
import com.cardinalcommerce.cardinalmobilesdk.models.CardinalConfigurationParameters;
import com.cardinalcommerce.cardinalmobilesdk.models.ValidateResponse;
import com.cardinalcommerce.cardinalmobilesdk.services.CardinalInitService;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreeDSecure {
    private static String sDFReferenceId;

    @Deprecated
    public static void performVerification(final BraintreeFragment fragment, CardBuilder cardBuilder, final String amount) {
        TokenizationClient.tokenize(fragment, cardBuilder, new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                ThreeDSecure.performVerification(fragment, paymentMethodNonce.getNonce(), amount);
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
            }
        });
    }

    @Deprecated
    public static void performVerification(BraintreeFragment fragment, String nonce, String amount) {
        ThreeDSecureRequest request = new ThreeDSecureRequest().nonce(nonce).amount(amount);
        ThreeDSecure.performVerification(fragment, request);
    }

    @Deprecated
    public static void performVerification(final BraintreeFragment fragment, CardBuilder cardBuilder, final ThreeDSecureRequest request) {
        if (request.getAmount() == null) {
            fragment.postCallback(new InvalidArgumentException("The ThreeDSecureRequest amount cannot be null"));
            return;
        }
        TokenizationClient.tokenize(fragment, cardBuilder, new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                request.nonce(paymentMethodNonce.getNonce());
                ThreeDSecure.performVerification(fragment, request);
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
            }
        });
    }

    public static void performVerification(final BraintreeFragment fragment, ThreeDSecureRequest request) {
        ThreeDSecureLookupListener lookupListener = new ThreeDSecureLookupListener(){

            @Override
            public void onLookupComplete(ThreeDSecureRequest request, ThreeDSecureLookup lookup) {
                fragment.sendAnalyticsEvent("three-d-secure.perform-verification.default-lookup-listener");
                ThreeDSecure.continuePerformVerification(fragment, request, lookup);
            }
        };
        ThreeDSecure.performVerification(fragment, request, lookupListener);
    }

    public static void performVerification(final BraintreeFragment fragment, final ThreeDSecureRequest request, final ThreeDSecureLookupListener lookupListener) {
        if (request.getAmount() == null || request.getNonce() == null) {
            fragment.postCallback(new InvalidArgumentException("The ThreeDSecureRequest nonce and amount cannot be null"));
            return;
        }
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (!configuration.isThreeDSecureEnabled()) {
                    fragment.postCallback(new BraintreeException("Three D Secure is not enabled for this account. Please contact Braintree Support for assistance."));
                    return;
                }
                boolean supportsBrowserSwitch = ManifestValidator.isUrlSchemeDeclaredInAndroidManifest((Context)fragment.getApplicationContext(), (String)fragment.getReturnUrlScheme(), BraintreeBrowserSwitchActivity.class);
                if (!supportsBrowserSwitch) {
                    fragment.sendAnalyticsEvent("three-d-secure.invalid-manifest");
                    fragment.postCallback(new BraintreeException("BraintreeBrowserSwitchActivity missing, incorrectly configured in AndroidManifest.xml or another app defines the same browser switch url as this app. See https://developers.braintreepayments.com/guides/client-sdk/android/v2#browser-switch for the correct configuration"));
                    return;
                }
                if (configuration.getCardinalAuthenticationJwt() == null && "2".equals(request.getVersionRequested())) {
                    fragment.postCallback(new BraintreeException("Merchant is not configured for 3DS 2.0. Please contact Braintree Support for assistance."));
                    return;
                }
                fragment.sendAnalyticsEvent("three-d-secure.initialized");
                if ("1".equals(request.getVersionRequested())) {
                    ThreeDSecure.performThreeDSecureLookup(fragment, request, lookupListener);
                    return;
                }
                ThreeDSecure.configureCardinal(fragment, configuration, request);
                Cardinal cardinal = Cardinal.getInstance();
                cardinal.init(configuration.getCardinalAuthenticationJwt(), new CardinalInitService(){

                    public void onSetupCompleted(String consumerSessionId) {
                        sDFReferenceId = consumerSessionId;
                        ThreeDSecure.performThreeDSecureLookup(fragment, request, lookupListener);
                        fragment.sendAnalyticsEvent("three-d-secure.cardinal-sdk.init.setup-completed");
                    }

                    public void onValidated(ValidateResponse validateResponse, String serverJWT) {
                        ThreeDSecure.performThreeDSecureLookup(fragment, request, lookupListener);
                        fragment.sendAnalyticsEvent("three-d-secure.cardinal-sdk.init.setup-failed");
                    }
                });
            }
        });
    }

    public static void continuePerformVerification(BraintreeFragment fragment, ThreeDSecureRequest request, ThreeDSecureLookup threeDSecureLookup) {
        boolean showChallenge = threeDSecureLookup.getAcsUrl() != null;
        String threeDSecureVersion = threeDSecureLookup.getThreeDSecureVersion();
        fragment.sendAnalyticsEvent(String.format("three-d-secure.verification-flow.challenge-presented.%b", showChallenge));
        fragment.sendAnalyticsEvent(String.format("three-d-secure.verification-flow.3ds-version.%s", threeDSecureVersion));
        if (!showChallenge) {
            ThreeDSecure.completeVerificationFlowWithNoncePayload(fragment, threeDSecureLookup.getCardNonce());
            return;
        }
        if (!threeDSecureVersion.startsWith("2.")) {
            fragment.browserSwitch(13487, ThreeDSecureV1BrowserSwitchHelper.getUrl(fragment.getReturnUrlScheme(), fragment.getConfiguration().getAssetsUrl(), request, threeDSecureLookup));
            return;
        }
        ThreeDSecure.performCardinalAuthentication(fragment, threeDSecureLookup);
    }

    public static void prepareLookup(final BraintreeFragment fragment, final ThreeDSecureRequest request, final ThreeDSecurePrepareLookupListener prepareLookupListener) {
        final JSONObject lookupJSON = new JSONObject();
        try {
            lookupJSON.put("authorizationFingerprint", (Object)fragment.getAuthorization().getBearer()).put("braintreeLibraryVersion", (Object)"Android-3.14.0").put("nonce", (Object)request.getNonce()).put("clientMetadata", (Object)new JSONObject().put("requestedThreeDSecureVersion", (Object)"2").put("sdkVersion", (Object)"3.14.0"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (configuration.getCardinalAuthenticationJwt() == null) {
                    fragment.postCallback(new BraintreeException("Merchant is not configured for 3DS 2.0. Please contact Braintree Support for assistance."));
                    return;
                }
                ThreeDSecure.configureCardinal(fragment, configuration, request);
                Cardinal cardinal = Cardinal.getInstance();
                cardinal.init(configuration.getCardinalAuthenticationJwt(), new CardinalInitService(){

                    public void onSetupCompleted(String consumerSessionId) {
                        sDFReferenceId = consumerSessionId;
                        try {
                            lookupJSON.put("dfReferenceId", (Object)sDFReferenceId);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        prepareLookupListener.onPrepareLookupComplete(request, lookupJSON.toString());
                    }

                    public void onValidated(ValidateResponse validateResponse, String serverJWT) {
                        prepareLookupListener.onPrepareLookupComplete(request, lookupJSON.toString());
                    }
                });
            }
        });
    }

    public static void initializeChallengeWithLookupResponse(BraintreeFragment fragment, String lookupResponse) {
        ThreeDSecure.initializeChallengeWithLookupResponse(fragment, null, lookupResponse);
    }

    public static void initializeChallengeWithLookupResponse(BraintreeFragment fragment, ThreeDSecureRequest threeDSecureRequest, String lookupResponse) {
        try {
            ThreeDSecureLookup threeDSecureLookup = ThreeDSecureLookup.fromJson(lookupResponse);
            boolean showChallenge = threeDSecureLookup.getAcsUrl() != null;
            String threeDSecureVersion = threeDSecureLookup.getThreeDSecureVersion();
            if (!showChallenge) {
                ThreeDSecure.completeVerificationFlowWithNoncePayload(fragment, threeDSecureLookup.getCardNonce());
                return;
            }
            if (!threeDSecureVersion.startsWith("2.")) {
                fragment.browserSwitch(13487, ThreeDSecureV1BrowserSwitchHelper.getUrl(fragment.getReturnUrlScheme(), fragment.getConfiguration().getAssetsUrl(), threeDSecureRequest, threeDSecureLookup));
                return;
            }
            ThreeDSecure.performCardinalAuthentication(fragment, threeDSecureLookup);
        }
        catch (JSONException e) {
            fragment.postCallback((Exception)((Object)e));
        }
    }

    private static void configureCardinal(BraintreeFragment fragment, Configuration configuration, ThreeDSecureRequest request) {
        CardinalEnvironment cardinalEnvironment = CardinalEnvironment.STAGING;
        if ("production".equalsIgnoreCase(configuration.getEnvironment())) {
            cardinalEnvironment = CardinalEnvironment.PRODUCTION;
        }
        CardinalConfigurationParameters cardinalConfigurationParameters = new CardinalConfigurationParameters();
        cardinalConfigurationParameters.setEnvironment(cardinalEnvironment);
        cardinalConfigurationParameters.setTimeout(8000);
        cardinalConfigurationParameters.setEnableQuickAuth(false);
        cardinalConfigurationParameters.setEnableDFSync(true);
        cardinalConfigurationParameters.setUICustomization(request.getUiCustomization());
        Cardinal cardinal = Cardinal.getInstance();
        cardinal.configure(fragment.getApplicationContext(), cardinalConfigurationParameters);
    }

    static void authenticateCardinalJWT(final BraintreeFragment fragment, ThreeDSecureLookup threeDSecureLookup, String cardinalJWT) {
        final CardNonce lookupCardNonce = threeDSecureLookup.getCardNonce();
        fragment.sendAnalyticsEvent("three-d-secure.verification-flow.upgrade-payment-method.started");
        String lookupNonce = lookupCardNonce.getNonce();
        JSONObject body = new JSONObject();
        try {
            body.put("jwt", (Object)cardinalJWT);
            body.put("paymentMethodNonce", (Object)lookupNonce);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        fragment.getHttpClient().post(TokenizationClient.versionedPath("payment_methods/" + lookupNonce + "/three_d_secure/authenticate_from_jwt"), body.toString(), new HttpResponseCallback(){

            public void success(String responseBody) {
                ThreeDSecureAuthenticationResponse authenticationResponse = ThreeDSecureAuthenticationResponse.fromJson(responseBody);
                CardNonce nonce = ThreeDSecureAuthenticationResponse.getNonceWithAuthenticationDetails(responseBody, lookupCardNonce);
                if (authenticationResponse.getErrors() != null) {
                    fragment.sendAnalyticsEvent("three-d-secure.verification-flow.upgrade-payment-method.failure.returned-lookup-nonce");
                    nonce.getThreeDSecureInfo().setErrorMessage(authenticationResponse.getErrors());
                    ThreeDSecure.completeVerificationFlowWithNoncePayload(fragment, nonce);
                } else {
                    fragment.sendAnalyticsEvent("three-d-secure.verification-flow.upgrade-payment-method.succeeded");
                    ThreeDSecure.completeVerificationFlowWithNoncePayload(fragment, nonce);
                }
            }

            public void failure(Exception exception) {
                fragment.sendAnalyticsEvent("three-d-secure.verification-flow.upgrade-payment-method.errored");
                fragment.postCallback(exception);
            }
        });
    }

    protected static void onActivityResult(BraintreeFragment fragment, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        Uri resultUri = data.getData();
        if (resultUri != null) {
            String authResponse = resultUri.getQueryParameter("auth_response");
            ThreeDSecureAuthenticationResponse authenticationResponse = ThreeDSecureAuthenticationResponse.fromJson(authResponse);
            if (authenticationResponse.isSuccess()) {
                ThreeDSecure.completeVerificationFlowWithNoncePayload(fragment, authenticationResponse.getCardNonce());
            } else {
                fragment.postCallback(new ErrorWithResponse(422, authResponse));
            }
        } else {
            ThreeDSecureLookup threeDSecureLookup = (ThreeDSecureLookup)data.getParcelableExtra("com.braintreepayments.api.ThreeDSecureActivity.EXTRA_THREE_D_SECURE_LOOKUP");
            ValidateResponse validateResponse = (ValidateResponse)data.getSerializableExtra("com.braintreepayments.api.ThreeDSecureActivity.EXTRA_VALIDATION_RESPONSE");
            String jwt = data.getStringExtra("com.braintreepayments.api.ThreeDSecureActivity.EXTRA_JWT");
            fragment.sendAnalyticsEvent(String.format("three-d-secure.verification-flow.cardinal-sdk.action-code.%s", validateResponse.getActionCode().name().toLowerCase()));
            switch (validateResponse.getActionCode()) {
                case FAILURE: 
                case SUCCESS: 
                case NOACTION: {
                    ThreeDSecure.authenticateCardinalJWT(fragment, threeDSecureLookup, jwt);
                    fragment.sendAnalyticsEvent("three-d-secure.verification-flow.completed");
                    break;
                }
                case ERROR: 
                case TIMEOUT: {
                    fragment.postCallback(new BraintreeException(validateResponse.getErrorDescription()));
                    fragment.sendAnalyticsEvent("three-d-secure.verification-flow.failed");
                    break;
                }
                case CANCEL: {
                    fragment.postCancelCallback(13487);
                    fragment.sendAnalyticsEvent("three-d-secure.verification-flow.canceled");
                }
            }
        }
    }

    private static void completeVerificationFlowWithNoncePayload(BraintreeFragment fragment, CardNonce noncePayload) {
        ThreeDSecureInfo info = noncePayload.getThreeDSecureInfo();
        fragment.sendAnalyticsEvent(String.format("three-d-secure.verification-flow.liability-shifted.%b", info.isLiabilityShifted()));
        fragment.sendAnalyticsEvent(String.format("three-d-secure.verification-flow.liability-shift-possible.%b", info.isLiabilityShiftPossible()));
        fragment.postCallback(noncePayload);
    }

    private static void performThreeDSecureLookup(final BraintreeFragment fragment, final ThreeDSecureRequest request, final ThreeDSecureLookupListener lookupListener) {
        fragment.getHttpClient().post(TokenizationClient.versionedPath("payment_methods/" + request.getNonce() + "/three_d_secure/lookup"), request.build(sDFReferenceId), new HttpResponseCallback(){

            public void success(String responseBody) {
                try {
                    lookupListener.onLookupComplete(request, ThreeDSecureLookup.fromJson(responseBody));
                }
                catch (JSONException exception) {
                    fragment.postCallback((Exception)((Object)exception));
                }
            }

            public void failure(Exception exception) {
                fragment.postCallback(exception);
            }
        });
    }

    private static void performCardinalAuthentication(BraintreeFragment fragment, ThreeDSecureLookup threeDSecureLookup) {
        fragment.sendAnalyticsEvent("three-d-secure.verification-flow.started");
        Bundle extras = new Bundle();
        extras.putParcelable("com.braintreepayments.api.ThreeDSecureActivity.EXTRA_THREE_D_SECURE_LOOKUP", (Parcelable)threeDSecureLookup);
        Intent intent = new Intent(fragment.getApplicationContext(), ThreeDSecureActivity.class);
        intent.putExtras(extras);
        fragment.startActivityForResult(intent, 13487);
    }
}

