/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.pm.PackageManager;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.Venmo;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PreferredPaymentMethodsListener;
import com.braintreepayments.api.internal.BraintreeGraphQLHttpClient;
import com.braintreepayments.api.models.PreferredPaymentMethodsResult;

public class PreferredPaymentMethods {
    private static final int NO_FLAGS = 0;
    private static final String PAYPAL_APP_PACKAGE = "com.paypal.android.p2pmobile";
    private static final String VENMO_APP_PACKAGE = "com.venmo";

    public static void fetchPreferredPaymentMethods(final BraintreeFragment fragment, final PreferredPaymentMethodsListener listener) {
        boolean isPayPalAppInstalled = false;
        boolean isVenmoAppInstalled = false;
        try {
            PackageManager packageManager = fragment.getApplicationContext().getPackageManager();
            isPayPalAppInstalled = packageManager.getApplicationInfo(PAYPAL_APP_PACKAGE, 0) != null;
            isVenmoAppInstalled = Venmo.isVenmoInstalled(fragment.getApplicationContext());
        }
        catch (PackageManager.NameNotFoundException packageManager) {
            // empty catch block
        }
        fragment.sendAnalyticsEvent(String.format("preferred-payment-methods.venmo.app-installed.%b", isVenmoAppInstalled));
        if (isPayPalAppInstalled) {
            fragment.sendAnalyticsEvent("preferred-payment-methods.paypal.app-installed.true");
            listener.onPreferredPaymentMethodsFetched(new PreferredPaymentMethodsResult().isPayPalPreferred(true).isVenmoPreferred(isVenmoAppInstalled));
            return;
        }
        BraintreeGraphQLHttpClient graphQLClient = fragment.getGraphQLHttpClient();
        if (graphQLClient == null) {
            fragment.sendAnalyticsEvent("preferred-payment-methods.api-disabled");
            listener.onPreferredPaymentMethodsFetched(new PreferredPaymentMethodsResult().isPayPalPreferred(isPayPalAppInstalled).isVenmoPreferred(isVenmoAppInstalled));
            return;
        }
        String query = "{ \"query\": \"query PreferredPaymentMethods { preferredPaymentMethods { paypalPreferred } }\" }";
        final boolean finalIsVenmoAppInstalled = isVenmoAppInstalled;
        graphQLClient.post(query, new HttpResponseCallback(){

            public void success(String responseBody) {
                PreferredPaymentMethodsResult result = PreferredPaymentMethodsResult.fromJSON(responseBody, finalIsVenmoAppInstalled);
                fragment.sendAnalyticsEvent(String.format("preferred-payment-methods.paypal.api-detected.%b", result.isPayPalPreferred()));
                listener.onPreferredPaymentMethodsFetched(result);
            }

            public void failure(Exception exception) {
                fragment.sendAnalyticsEvent("preferred-payment-methods.api-error");
                listener.onPreferredPaymentMethodsFetched(new PreferredPaymentMethodsResult().isPayPalPreferred(false).isVenmoPreferred(finalIsVenmoAppInstalled));
            }
        });
    }
}

