/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.PayPal;
import com.braintreepayments.api.PayPalTwoFactorAuthSharedPreferences;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PayPalTwoFactorAuthCallback;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PayPalAccountNonce;
import com.braintreepayments.api.models.PayPalTwoFactorAuthRequest;
import com.braintreepayments.api.models.PayPalTwoFactorAuthResponse;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.paypal.android.sdk.data.collector.PayPalDataCollector;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalTwoFactorAuth {
    public static final String SUCCESS_PATH = "success";
    public static final String CANCEL_PATH = "cancel";
    private static final String PAYPAL_ACCOUNT_PATH = "payment_methods/paypal_accounts";
    private static final String CREATE_SINGLE_PAYMENT_PATH = "paypal_hermes/create_payment_resource";

    public static void performTwoFactorLookup(final BraintreeFragment fragment, final PayPalTwoFactorAuthRequest request, final PayPalTwoFactorAuthCallback callback) {
        fragment.sendAnalyticsEvent("paypal-two-factor.perform-two-factor-lookup.started");
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (!configuration.isPayPalEnabled()) {
                    fragment.postCallback(new BraintreeException("PayPal is not enabled. See https://developers.braintreepayments.com/guides/paypal/overview/android/ for more information."));
                    return;
                }
                if (!PayPal.isManifestValid(fragment)) {
                    fragment.postCallback(new BraintreeException("BraintreeBrowserSwitchActivity missing, incorrectly configured in AndroidManifest.xml or another app defines the same browser switch url as this app. See https://developers.braintreepayments.com/guides/client-sdk/android/#browser-switch for the correct configuration"));
                    return;
                }
                PayPalTwoFactorAuth.paypalHermesLookup(fragment, request, callback);
            }
        });
    }

    private static void paypalHermesLookup(final BraintreeFragment fragment, PayPalTwoFactorAuthRequest request, final PayPalTwoFactorAuthCallback callback) {
        String versionedPath = "/v1/paypal_hermes/create_payment_resource";
        String requestJson = request.toJson(fragment.getAuthorization().getBearer(), fragment.getReturnUrlScheme());
        fragment.getHttpClient().post(versionedPath, requestJson, new HttpResponseCallback(){

            public void success(String responseBody) {
                try {
                    PayPalTwoFactorAuthResponse response = PayPalTwoFactorAuthResponse.fromJson(responseBody, fragment.getAuthorization().getBearer());
                    fragment.sendAnalyticsEvent("paypal-two-factor.paypal-hermes-lookup.succeeded");
                    PayPalTwoFactorAuth.fetchPayPalAccount(fragment, response, callback);
                }
                catch (JSONException e) {
                    fragment.sendAnalyticsEvent("paypal-two-factor.paypal-hermes-lookup.failed");
                    callback.onLookupFailure((Exception)((Object)e));
                }
            }

            public void failure(Exception e) {
                fragment.sendAnalyticsEvent("paypal-two-factor.paypal-hermes-lookup.failed");
                callback.onLookupFailure(e);
            }
        });
    }

    private static void fetchPayPalAccount(final BraintreeFragment fragment, final PayPalTwoFactorAuthResponse response, final PayPalTwoFactorAuthCallback callback) {
        String versionedPath = "/v1/payment_methods/paypal_accounts";
        String request = response.toJson(PayPalDataCollector.getClientMetadataId((Context)fragment.getApplicationContext()));
        fragment.getHttpClient().post(versionedPath, request, new HttpResponseCallback(){

            public void success(String responseBody) {
                try {
                    String authenticateUrl = response.getAuthenticateUrl();
                    JSONObject payPalAccountResponse = new JSONObject(responseBody);
                    payPalAccountResponse.getJSONArray("paypalAccounts").getJSONObject(0).put("authenticateUrl", (Object)authenticateUrl);
                    PayPalAccountNonce payPalAccountNonce = PayPalAccountNonce.fromJson(payPalAccountResponse.toString());
                    fragment.sendAnalyticsEvent("paypal-two-factor.fetch-paypal-account.succeeded");
                    callback.onLookupResult(payPalAccountNonce);
                }
                catch (JSONException e) {
                    fragment.sendAnalyticsEvent("paypal-two-factor.fetch-paypal-account.failed");
                    fragment.postCallback((Exception)((Object)e));
                }
            }

            public void failure(Exception e) {
                fragment.sendAnalyticsEvent("paypal-two-factor.fetch-paypal-account.failed");
                fragment.postCallback(e);
            }
        });
    }

    public static void continueTwoFactorAuthentication(BraintreeFragment fragment, PaymentMethodNonce paymentMethodNonce) {
        fragment.sendAnalyticsEvent("paypal-two-factor.continue-two-factor-authentication.started");
        PayPalAccountNonce payPalAccountNonce = (PayPalAccountNonce)paymentMethodNonce;
        PayPalTwoFactorAuthSharedPreferences.persistPayPalAccountNonce(fragment, payPalAccountNonce);
        String authenticateUrl = payPalAccountNonce.getAuthenticateUrl();
        if (authenticateUrl == null) {
            fragment.sendAnalyticsEvent("paypal-two-factor.continue-two-factor-authentication.no-two-factor-required");
            fragment.postCallback(payPalAccountNonce);
        } else {
            fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.started");
            fragment.browserSwitch(13597, authenticateUrl);
        }
    }

    protected static void onActivityResult(BraintreeFragment fragment, int resultCode, Intent data) {
        PayPalAccountNonce payPalAccountNonce = PayPalTwoFactorAuthSharedPreferences.getPersistedPayPalAccountNonce(fragment);
        if (resultCode == -1 && data != null && payPalAccountNonce != null) {
            String host = null;
            Uri intentData = data.getData();
            if (intentData != null) {
                host = intentData.getHost();
            }
            if (host != null) {
                switch (host) {
                    case "success": {
                        fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.succeeded");
                        fragment.postCallback(payPalAccountNonce);
                        break;
                    }
                    case "cancel": {
                        fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.canceled");
                        fragment.postCancelCallback(13597);
                        break;
                    }
                    default: {
                        fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.failed");
                        fragment.postCallback(new BraintreeException("Host path unknown: " + host));
                        break;
                    }
                }
            } else {
                fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.failed");
                fragment.postCallback(new BraintreeException("Host missing from browser switch response."));
            }
        } else {
            fragment.sendAnalyticsEvent("paypal-two-factor.browser-switch.canceled");
            fragment.postCancelCallback(13597);
        }
    }
}

