/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeBrowserSwitchActivity;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.exceptions.BrowserSwitchException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.interfaces.PayPalApprovalCallback;
import com.braintreepayments.api.interfaces.PayPalApprovalHandler;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.internal.BraintreeSharedPreferences;
import com.braintreepayments.api.internal.ManifestValidator;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PayPalAccountBuilder;
import com.braintreepayments.api.models.PayPalAccountNonce;
import com.braintreepayments.api.models.PayPalConfiguration;
import com.braintreepayments.api.models.PayPalPaymentResource;
import com.braintreepayments.api.models.PayPalProductAttributes;
import com.braintreepayments.api.models.PayPalRequest;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.PostalAddress;
import com.paypal.android.sdk.onetouch.core.BillingAgreementRequest;
import com.paypal.android.sdk.onetouch.core.CheckoutRequest;
import com.paypal.android.sdk.onetouch.core.PayPalLineItem;
import com.paypal.android.sdk.onetouch.core.PayPalOneTouchCore;
import com.paypal.android.sdk.onetouch.core.Request;
import com.paypal.android.sdk.onetouch.core.Result;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;
import com.paypal.android.sdk.onetouch.core.sdk.PendingRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPal {
    public static final String PRODUCT_ATTRIBUTES = "product_attributes";
    public static final String CHARGE_PATTERN = "charge_pattern";
    public static final String NAME = "name";
    public static final String PRODUCT_CODE = "product_code";
    private static final String REQUEST_KEY = "com.braintreepayments.api.PayPal.REQUEST_KEY";
    private static final String REQUEST_TYPE_KEY = "com.braintreepayments.api.PayPal.REQUEST_TYPE_KEY";
    private static final String PAYPAL_REQUEST_KEY = "com.braintreepayments.api.PayPal.PAYPAL_REQUEST_KEY";
    private static final String SETUP_BILLING_AGREEMENT_ENDPOINT = "paypal_hermes/setup_billing_agreement";
    private static final String CREATE_SINGLE_PAYMENT_ENDPOINT = "paypal_hermes/create_payment_resource";
    private static final String NO_SHIPPING_KEY = "no_shipping";
    private static final String ADDRESS_OVERRIDE_KEY = "address_override";
    private static final String LOCALE_CODE_KEY = "locale_code";
    private static final String DESCRIPTION_KEY = "description";
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorization_fingerprint";
    private static final String TOKENIZATION_KEY = "client_key";
    private static final String RETURN_URL_KEY = "return_url";
    private static final String OFFER_CREDIT_KEY = "offer_paypal_credit";
    private static final String CANCEL_URL_KEY = "cancel_url";
    private static final String EXPERIENCE_PROFILE_KEY = "experience_profile";
    private static final String AMOUNT_KEY = "amount";
    private static final String CURRENCY_ISO_CODE_KEY = "currency_iso_code";
    private static final String INTENT_KEY = "intent";
    private static final String LANDING_PAGE_TYPE_KEY = "landing_page_type";
    private static final String USER_ACTION_KEY = "useraction";
    private static final String DISPLAY_NAME_KEY = "brand_name";
    private static final String SHIPPING_ADDRESS_KEY = "shipping_address";
    private static final String MERCHANT_ACCOUNT_ID = "merchant_account_id";
    private static final String LINE_ITEMS_KEY = "line_items";

    public static void requestBillingAgreement(BraintreeFragment fragment, PayPalRequest request) {
        PayPal.requestBillingAgreement(fragment, request, null);
    }

    public static void requestBillingAgreement(BraintreeFragment fragment, PayPalRequest request, PayPalApprovalHandler handler) {
        if (request.getAmount() == null) {
            fragment.sendAnalyticsEvent("paypal.billing-agreement.selected");
            if (request.shouldOfferCredit()) {
                fragment.sendAnalyticsEvent("paypal.billing-agreement.credit.offered");
            }
            PayPal.requestOneTimePayment(fragment, request, true, handler);
        } else {
            fragment.postCallback(new BraintreeException("There must be no amount specified for the Billing Agreement flow"));
        }
    }

    public static void requestOneTimePayment(BraintreeFragment fragment, PayPalRequest request) {
        PayPal.requestOneTimePayment(fragment, request, null);
    }

    public static void requestOneTimePayment(BraintreeFragment fragment, PayPalRequest request, PayPalApprovalHandler handler) {
        if (request.getAmount() != null) {
            fragment.sendAnalyticsEvent("paypal.single-payment.selected");
            if (request.shouldOfferCredit()) {
                fragment.sendAnalyticsEvent("paypal.single-payment.credit.offered");
            }
            PayPal.requestOneTimePayment(fragment, request, false, handler);
        } else {
            fragment.postCallback(new BraintreeException("An amount must be specified for the Single Payment flow."));
        }
    }

    private static void requestOneTimePayment(final BraintreeFragment fragment, final PayPalRequest paypalRequest, final boolean isBillingAgreement, final PayPalApprovalHandler handler) {
        final HttpResponseCallback callback = new HttpResponseCallback(){

            public void success(String responseBody) {
                PayPalPaymentResource paypalPaymentResource;
                try {
                    paypalPaymentResource = PayPalPaymentResource.fromJson(responseBody);
                }
                catch (JSONException e) {
                    fragment.postCallback((Exception)((Object)e));
                    return;
                }
                String redirectUrl = Uri.parse((String)paypalPaymentResource.getRedirectUrl()).buildUpon().appendQueryParameter(PayPal.USER_ACTION_KEY, paypalRequest.getUserAction()).toString();
                Object request = isBillingAgreement ? PayPal.getBillingAgreementRequest(fragment, redirectUrl) : PayPal.getCheckoutRequest(fragment, redirectUrl);
                PayPal.startPayPal(fragment, (Request)request, handler);
            }

            public void failure(Exception e) {
                fragment.postCallback(e);
            }
        };
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (!configuration.isPayPalEnabled()) {
                    fragment.postCallback(new BraintreeException("PayPal is not enabled. See https://developers.braintreepayments.com/guides/paypal/overview/android/ for more information."));
                    return;
                }
                if (!PayPal.isManifestValid(fragment)) {
                    fragment.sendAnalyticsEvent("paypal.invalid-manifest");
                    fragment.postCallback(new BraintreeException("BraintreeBrowserSwitchActivity missing, incorrectly configured in AndroidManifest.xml or another app defines the same browser switch url as this app. See https://developers.braintreepayments.com/guides/client-sdk/android/#browser-switch for the correct configuration"));
                    return;
                }
                try {
                    PayPal.persistPayPalRequest(fragment.getApplicationContext(), paypalRequest);
                    PayPal.createPaymentResource(fragment, paypalRequest, isBillingAgreement, callback);
                }
                catch (JSONException ex) {
                    fragment.postCallback((Exception)((Object)ex));
                }
            }
        });
    }

    private static void createPaymentResource(BraintreeFragment fragment, PayPalRequest request, boolean isBillingAgreement, HttpResponseCallback callback) throws JSONException {
        String currencyCode = request.getCurrencyCode();
        if (currencyCode == null) {
            currencyCode = fragment.getConfiguration().getPayPal().getCurrencyIsoCode();
        }
        CheckoutRequest checkoutRequest = PayPal.getCheckoutRequest(fragment, null);
        JSONObject parameters = new JSONObject().put(RETURN_URL_KEY, (Object)checkoutRequest.getSuccessUrl()).put(CANCEL_URL_KEY, (Object)checkoutRequest.getCancelUrl()).put(OFFER_CREDIT_KEY, request.shouldOfferCredit());
        if (fragment.getAuthorization() instanceof ClientToken) {
            parameters.put(AUTHORIZATION_FINGERPRINT_KEY, (Object)fragment.getAuthorization().getBearer());
        } else {
            parameters.put(TOKENIZATION_KEY, (Object)fragment.getAuthorization().getBearer());
        }
        if (!isBillingAgreement) {
            parameters.put(AMOUNT_KEY, (Object)request.getAmount()).put(CURRENCY_ISO_CODE_KEY, (Object)currencyCode).put(INTENT_KEY, (Object)request.getIntent());
            if (!request.getLineItems().isEmpty()) {
                JSONArray lineItems = new JSONArray();
                for (PayPalLineItem lineItem : request.getLineItems()) {
                    lineItems.put((Object)lineItem.toJson());
                }
                parameters.put(LINE_ITEMS_KEY, (Object)lineItems);
            }
        } else {
            PayPalProductAttributes productAttributes;
            if (!TextUtils.isEmpty((CharSequence)request.getBillingAgreementDescription())) {
                parameters.put(DESCRIPTION_KEY, (Object)request.getBillingAgreementDescription());
            }
            if ((productAttributes = request.getProductAttributes()) != null) {
                parameters.put(PRODUCT_ATTRIBUTES, (Object)new JSONObject().put(CHARGE_PATTERN, (Object)productAttributes.getChargePattern()).put(NAME, (Object)productAttributes.getName()).put(PRODUCT_CODE, (Object)productAttributes.getProductCode()));
            }
        }
        JSONObject experienceProfile = new JSONObject();
        experienceProfile.put(NO_SHIPPING_KEY, !request.isShippingAddressRequired());
        experienceProfile.put(LANDING_PAGE_TYPE_KEY, (Object)request.getLandingPageType());
        String displayName = request.getDisplayName();
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            displayName = fragment.getConfiguration().getPayPal().getDisplayName();
        }
        experienceProfile.put(DISPLAY_NAME_KEY, (Object)displayName);
        if (request.getLocaleCode() != null) {
            experienceProfile.put(LOCALE_CODE_KEY, (Object)request.getLocaleCode());
        }
        if (request.getShippingAddressOverride() != null) {
            JSONObject shippingAddressJson;
            experienceProfile.put(ADDRESS_OVERRIDE_KEY, !request.isShippingAddressEditable());
            if (isBillingAgreement) {
                shippingAddressJson = new JSONObject();
                parameters.put(SHIPPING_ADDRESS_KEY, (Object)shippingAddressJson);
            } else {
                shippingAddressJson = parameters;
            }
            PostalAddress shippingAddress = request.getShippingAddressOverride();
            shippingAddressJson.put("line1", (Object)shippingAddress.getStreetAddress());
            shippingAddressJson.put("line2", (Object)shippingAddress.getExtendedAddress());
            shippingAddressJson.put("city", (Object)shippingAddress.getLocality());
            shippingAddressJson.put("state", (Object)shippingAddress.getRegion());
            shippingAddressJson.put("postal_code", (Object)shippingAddress.getPostalCode());
            shippingAddressJson.put("country_code", (Object)shippingAddress.getCountryCodeAlpha2());
            shippingAddressJson.put("recipient_name", (Object)shippingAddress.getRecipientName());
        } else {
            experienceProfile.put(ADDRESS_OVERRIDE_KEY, false);
        }
        if (request.getMerchantAccountId() != null) {
            parameters.put(MERCHANT_ACCOUNT_ID, (Object)request.getMerchantAccountId());
        }
        parameters.put(EXPERIENCE_PROFILE_KEY, (Object)experienceProfile);
        String apiUrl = isBillingAgreement ? SETUP_BILLING_AGREEMENT_ENDPOINT : CREATE_SINGLE_PAYMENT_ENDPOINT;
        String versionedPath = "/v1/" + apiUrl;
        fragment.getHttpClient().post(versionedPath, parameters.toString(), callback);
    }

    private static void startPayPal(final BraintreeFragment fragment, Request request, PayPalApprovalHandler handler) {
        PayPal.persistRequest(fragment.getApplicationContext(), request);
        PayPalApprovalCallback callback = null;
        if (handler == null) {
            handler = PayPal.getDefaultApprovalHandler(fragment);
        } else {
            callback = new PayPalApprovalCallback(){

                @Override
                public void onComplete(Intent data) {
                    PayPal.onActivityResult(fragment, -1, data);
                }

                @Override
                public void onCancel() {
                    fragment.postCancelCallback(13591);
                }
            };
        }
        handler.handleApproval(request, callback);
    }

    private static PayPalApprovalHandler getDefaultApprovalHandler(final BraintreeFragment fragment) {
        return new PayPalApprovalHandler(){

            @Override
            public void handleApproval(Request request, PayPalApprovalCallback paypalApprovalCallback) {
                if (!fragment.isActive()) {
                    return;
                }
                PendingRequest pendingRequest = PayPalOneTouchCore.getStartIntent((Context)fragment.getApplicationContext(), (Request)request);
                String paymentType = PayPal.paymentTypeForRequest(request);
                if (pendingRequest.isSuccess() && pendingRequest.getRequestTarget() == RequestTarget.wallet) {
                    fragment.sendAnalyticsEvent(paymentType + ".app-switch.started");
                    fragment.startActivityForResult(pendingRequest.getIntent(), 13591);
                } else if (pendingRequest.isSuccess() && pendingRequest.getRequestTarget() == RequestTarget.browser) {
                    fragment.sendAnalyticsEvent(paymentType + ".browser-switch.started");
                    fragment.browserSwitch(13591, pendingRequest.getIntent());
                } else {
                    fragment.sendAnalyticsEvent(paymentType + ".initiate.failed");
                }
            }
        };
    }

    protected static void onActivityResult(BraintreeFragment fragment, int resultCode, Intent data) {
        Request request = PayPal.getPersistedRequest(fragment.getApplicationContext());
        String paymentType = PayPal.paymentTypeForRequest(request);
        String switchType = PayPal.switchTypeForIntent(data);
        String eventPrefix = paymentType + "." + switchType;
        if (resultCode == -1 && data != null && request != null) {
            Result result = PayPalOneTouchCore.parseResponse((Context)fragment.getApplicationContext(), (Request)request, (Intent)data);
            switch (result.getResultType()) {
                case Error: {
                    fragment.postCallback(new BrowserSwitchException(result.getError().getMessage()));
                    fragment.sendAnalyticsEvent(eventPrefix + ".failed");
                    break;
                }
                case Cancel: {
                    fragment.postCancelCallback(13591);
                    fragment.sendAnalyticsEvent(eventPrefix + ".canceled");
                    break;
                }
                case Success: {
                    PayPal.onSuccess(fragment, data, request, result);
                    fragment.sendAnalyticsEvent(eventPrefix + ".succeeded");
                }
            }
        } else {
            fragment.sendAnalyticsEvent(eventPrefix + ".canceled");
            if (resultCode != 0) {
                fragment.postCancelCallback(13591);
            }
        }
    }

    private static void onSuccess(final BraintreeFragment fragment, Intent data, Request request, Result result) {
        PayPalRequest paypalRequest = PayPal.getPersistedPayPalRequest(fragment.getApplicationContext());
        TokenizationClient.tokenize(fragment, PayPal.parseResponse(paypalRequest, request, result, data), new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                if (paymentMethodNonce instanceof PayPalAccountNonce && ((PayPalAccountNonce)paymentMethodNonce).getCreditFinancing() != null) {
                    fragment.sendAnalyticsEvent("paypal.credit.accepted");
                }
                fragment.postCallback(paymentMethodNonce);
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
            }
        });
    }

    private static PayPalAccountBuilder parseResponse(PayPalRequest paypalRequest, Request request, Result result, Intent intent) {
        PayPalAccountBuilder paypalAccountBuilder = new PayPalAccountBuilder().clientMetadataId(request.getClientMetadataId());
        if (paypalRequest != null && paypalRequest.getMerchantAccountId() != null) {
            paypalAccountBuilder.merchantAccountId(paypalRequest.getMerchantAccountId());
        }
        if (request instanceof CheckoutRequest && paypalRequest != null) {
            paypalAccountBuilder.intent(paypalRequest.getIntent());
        }
        if (PayPal.isAppSwitch(intent)) {
            paypalAccountBuilder.source("paypal-app");
        } else {
            paypalAccountBuilder.source("paypal-browser");
        }
        paypalAccountBuilder.oneTouchCoreData(result.getResponse());
        return paypalAccountBuilder;
    }

    @VisibleForTesting
    static CheckoutRequest getCheckoutRequest(BraintreeFragment fragment, String redirectUrl) {
        Uri uri;
        String pairingId;
        CheckoutRequest request = PayPal.populateRequestData(fragment, new CheckoutRequest()).approvalURL(redirectUrl);
        if (redirectUrl != null && (pairingId = (uri = Uri.parse((String)redirectUrl)).getQueryParameter("token")) != null) {
            request.pairingId(fragment.getApplicationContext(), pairingId);
        }
        return request;
    }

    @VisibleForTesting
    static BillingAgreementRequest getBillingAgreementRequest(BraintreeFragment fragment, String redirectUrl) {
        Uri uri;
        String pairingId;
        BillingAgreementRequest request = PayPal.populateRequestData(fragment, new BillingAgreementRequest()).approvalURL(redirectUrl);
        if (redirectUrl != null && (pairingId = (uri = Uri.parse((String)redirectUrl)).getQueryParameter("ba_token")) != null) {
            request.pairingId(fragment.getApplicationContext(), pairingId);
        }
        return request;
    }

    private static <T extends Request> T populateRequestData(BraintreeFragment fragment, T request) {
        String environment;
        PayPalConfiguration paypalConfiguration = fragment.getConfiguration().getPayPal();
        switch (paypalConfiguration.getEnvironment()) {
            case "live": {
                environment = "live";
                break;
            }
            case "offline": {
                environment = "mock";
                break;
            }
            default: {
                environment = paypalConfiguration.getEnvironment();
            }
        }
        String clientId = paypalConfiguration.getClientId();
        if (clientId == null && "mock".equals(environment)) {
            clientId = "FAKE-PAYPAL-CLIENT-ID";
        }
        request.environment(environment).clientId(clientId).cancelUrl(fragment.getReturnUrlScheme(), "cancel").successUrl(fragment.getReturnUrlScheme(), "success");
        return request;
    }

    private static boolean isAppSwitch(Intent data) {
        return data.getData() == null;
    }

    private static void persistPayPalRequest(Context context, PayPalRequest paypalRequest) {
        Parcel parcel = Parcel.obtain();
        paypalRequest.writeToParcel(parcel, 0);
        BraintreeSharedPreferences.getSharedPreferences((Context)context).edit().putString(PAYPAL_REQUEST_KEY, Base64.encodeToString((byte[])parcel.marshall(), (int)0)).apply();
    }

    private static void persistRequest(Context context, Request request) {
        Parcel parcel = Parcel.obtain();
        request.writeToParcel(parcel, 0);
        BraintreeSharedPreferences.getSharedPreferences((Context)context).edit().putString(REQUEST_KEY, Base64.encodeToString((byte[])parcel.marshall(), (int)0)).putString(REQUEST_TYPE_KEY, request.getClass().getSimpleName()).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PayPalRequest getPersistedPayPalRequest(Context context) {
        SharedPreferences prefs = BraintreeSharedPreferences.getSharedPreferences((Context)context);
        try {
            byte[] requestBytes = Base64.decode((String)prefs.getString(PAYPAL_REQUEST_KEY, ""), (int)0);
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(requestBytes, 0, requestBytes.length);
            parcel.setDataPosition(0);
            PayPalRequest payPalRequest = (PayPalRequest)PayPalRequest.CREATOR.createFromParcel(parcel);
            return payPalRequest;
        }
        catch (Exception exception) {
        }
        finally {
            prefs.edit().remove(PAYPAL_REQUEST_KEY).apply();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Request getPersistedRequest(Context context) {
        SharedPreferences prefs = BraintreeSharedPreferences.getSharedPreferences((Context)context);
        try {
            byte[] requestBytes = Base64.decode((String)prefs.getString(REQUEST_KEY, ""), (int)0);
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(requestBytes, 0, requestBytes.length);
            parcel.setDataPosition(0);
            String type = prefs.getString(REQUEST_TYPE_KEY, "");
            if (BillingAgreementRequest.class.getSimpleName().equals(type)) {
                Request request = (Request)BillingAgreementRequest.CREATOR.createFromParcel(parcel);
                return request;
            }
            if (CheckoutRequest.class.getSimpleName().equals(type)) {
                Request request = (Request)CheckoutRequest.CREATOR.createFromParcel(parcel);
                return request;
            }
        }
        catch (Exception exception) {
        }
        finally {
            prefs.edit().remove(REQUEST_KEY).remove(REQUEST_TYPE_KEY).apply();
        }
        return null;
    }

    static boolean isManifestValid(BraintreeFragment fragment) {
        return ManifestValidator.isUrlSchemeDeclaredInAndroidManifest((Context)fragment.getApplicationContext(), (String)fragment.getReturnUrlScheme(), BraintreeBrowserSwitchActivity.class);
    }

    private static String switchTypeForIntent(Intent data) {
        String switchType = "unknown";
        if (data != null) {
            switchType = data.getData() != null || data.getBooleanExtra("com.braintreepayments.api.WAS_BROWSER_SWITCH_RESULT", false) ? "browser-switch" : "app-switch";
        }
        return switchType;
    }

    private static String paymentTypeForRequest(Request request) {
        if (request instanceof BillingAgreementRequest) {
            return "paypal.billing-agreement";
        }
        if (request instanceof CheckoutRequest) {
            return "paypal.single-payment";
        }
        return "paypal.unknown";
    }
}

