/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.exceptions.ConfigurationException;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.LocalPaymentRequest;
import com.braintreepayments.api.models.LocalPaymentResult;
import com.paypal.android.sdk.data.collector.PayPalDataCollector;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPayment {
    private static final String LOCAL_PAYMENT_CANCEL = "local-payment-cancel";
    private static final String LOCAL_PAYMENT_SUCCESSS = "local-payment-success";
    private static String sMerchantAccountId;
    private static String sPaymentType;

    public static void startPayment(final BraintreeFragment fragment, final LocalPaymentRequest request, final BraintreeResponseListener<LocalPaymentRequest> listener) {
        if (request == null) {
            fragment.postCallback(new BraintreeException("A LocalPaymentRequest is required."));
            return;
        }
        if (request.getApprovalUrl() != null || request.getPaymentId() != null) {
            fragment.postCallback(new BraintreeException("LocalPaymentRequest is invalid, appovalUrl and paymentId should not be set."));
            return;
        }
        if (request.getPaymentType() == null || request.getAmount() == null) {
            fragment.postCallback(new BraintreeException("LocalPaymentRequest is invalid, paymentType and amount are required."));
            return;
        }
        if (listener == null) {
            fragment.postCallback(new BraintreeException("BraintreeResponseListener<LocalPaymentRequest> is required."));
            return;
        }
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (!configuration.getPayPal().isEnabled()) {
                    fragment.postCallback(new ConfigurationException("Local payments are not enabled for this merchant."));
                    return;
                }
                sMerchantAccountId = request.getMerchantAccountId();
                sPaymentType = request.getPaymentType();
                String returnUrl = fragment.getReturnUrlScheme() + "://" + LocalPayment.LOCAL_PAYMENT_SUCCESSS;
                String cancel = fragment.getReturnUrlScheme() + "://" + LocalPayment.LOCAL_PAYMENT_CANCEL;
                fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.start-payment.selected");
                fragment.getHttpClient().post("/v1/local_payments/create", request.build(returnUrl, cancel), new HttpResponseCallback(){

                    public void success(String responseBody) {
                        try {
                            JSONObject responseJson = new JSONObject(responseBody);
                            request.approvalUrl(responseJson.getJSONObject("paymentResource").getString("redirectUrl"));
                            request.paymentId(responseJson.getJSONObject("paymentResource").getString("paymentToken"));
                            fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.create.succeeded");
                            listener.onResponse(request);
                        }
                        catch (JSONException jsonException) {
                            this.failure((Exception)((Object)jsonException));
                        }
                    }

                    public void failure(Exception exception) {
                        fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.webswitch.initiate.failed");
                        fragment.postCallback(exception);
                    }
                });
            }
        });
    }

    public static void approvePayment(BraintreeFragment fragment, LocalPaymentRequest request) {
        fragment.browserSwitch(13596, request.getApprovalUrl());
        fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.webswitch.initiate.succeeded");
    }

    static void onActivityResult(final BraintreeFragment fragment, int resultCode, Intent data) {
        Uri uri;
        if (resultCode == 0) {
            LocalPayment.postCancelCallbackAndSendAnalytics(fragment);
            return;
        }
        Uri uri2 = uri = data == null ? null : data.getData();
        if (uri == null) {
            LocalPayment.postErrorCallbackAndSendAnalytics(fragment);
            return;
        }
        String responseString = uri.toString();
        if (responseString.toLowerCase().contains(LOCAL_PAYMENT_CANCEL.toLowerCase())) {
            LocalPayment.postCancelCallbackAndSendAnalytics(fragment);
            return;
        }
        JSONObject payload = new JSONObject();
        try {
            payload.put("merchant_account_id", (Object)sMerchantAccountId);
            JSONObject paypalAccount = new JSONObject().put("intent", (Object)"sale").put("response", (Object)new JSONObject().put("webURL", (Object)responseString)).put("options", (Object)new JSONObject().put("validate", false)).put("response_type", (Object)"web").put("correlation_id", (Object)PayPalDataCollector.getClientMetadataId((Context)fragment.getApplicationContext()));
            payload.put("paypal_account", (Object)paypalAccount);
            JSONObject metaData = new JSONObject().put("source", (Object)"client").put("integration", (Object)fragment.getIntegrationType()).put("sessionId", (Object)fragment.getSessionId());
            payload.put("_meta", (Object)metaData);
            fragment.getHttpClient().post("/v1/payment_methods/paypal_accounts", payload.toString(), new HttpResponseCallback(){

                public void success(String responseBody) {
                    try {
                        LocalPaymentResult result = LocalPaymentResult.fromJson(responseBody);
                        fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.tokenize.succeeded");
                        fragment.postCallback(result);
                    }
                    catch (JSONException jsonException) {
                        this.failure((Exception)((Object)jsonException));
                    }
                }

                public void failure(Exception exception) {
                    fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.tokenize.failed");
                    fragment.postCallback(exception);
                }
            });
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static String paymentTypeForAnalytics() {
        return sPaymentType != null ? sPaymentType : "unknown";
    }

    private static void postCancelCallbackAndSendAnalytics(BraintreeFragment fragment) {
        fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.webswitch.canceled");
        fragment.postCancelCallback(13596);
    }

    private static void postErrorCallbackAndSendAnalytics(BraintreeFragment fragment) {
        fragment.sendAnalyticsEvent(LocalPayment.paymentTypeForAnalytics() + ".local-payment.webswitch-response.invalid");
        fragment.postCallback(new BraintreeException("LocalPayment encountered an error, return URL is invalid."));
    }
}

