/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.internal.BraintreeSharedPreferences;
import com.braintreepayments.api.models.Configuration;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

class ConfigurationManager {
    static final long TTL = TimeUnit.MINUTES.toMillis(5L);
    @VisibleForTesting
    static boolean sFetchingConfiguration = false;

    private ConfigurationManager() {
    }

    static boolean isFetchingConfiguration() {
        return sFetchingConfiguration;
    }

    static void getConfiguration(final BraintreeFragment fragment, final @NonNull ConfigurationListener listener, final @NonNull BraintreeResponseListener<Exception> errorListener) {
        final String configUrl = Uri.parse((String)fragment.getAuthorization().getConfigUrl()).buildUpon().appendQueryParameter("configVersion", "3").build().toString();
        Configuration cachedConfig = ConfigurationManager.getCachedConfiguration(fragment.getApplicationContext(), configUrl + fragment.getAuthorization().getBearer());
        if (cachedConfig != null) {
            listener.onConfigurationFetched(cachedConfig);
        } else {
            sFetchingConfiguration = true;
            fragment.getHttpClient().get(configUrl, new HttpResponseCallback(){

                public void success(String responseBody) {
                    try {
                        Configuration configuration = Configuration.fromJson(responseBody);
                        ConfigurationManager.cacheConfiguration(fragment.getApplicationContext(), configUrl + fragment.getAuthorization().getBearer(), configuration);
                        sFetchingConfiguration = false;
                        listener.onConfigurationFetched(configuration);
                    }
                    catch (JSONException e) {
                        sFetchingConfiguration = false;
                        errorListener.onResponse(e);
                    }
                }

                public void failure(Exception exception) {
                    sFetchingConfiguration = false;
                    errorListener.onResponse(exception);
                }
            });
        }
    }

    @Nullable
    private static Configuration getCachedConfiguration(Context context, String configUrl) {
        SharedPreferences prefs = BraintreeSharedPreferences.getSharedPreferences((Context)context);
        configUrl = Base64.encodeToString((byte[])configUrl.getBytes(), (int)0);
        String timestampKey = configUrl + "_timestamp";
        if (System.currentTimeMillis() - prefs.getLong(timestampKey, 0L) > TTL) {
            return null;
        }
        try {
            return Configuration.fromJson(prefs.getString(configUrl, ""));
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static void cacheConfiguration(Context context, String configUrl, Configuration configuration) {
        configUrl = Base64.encodeToString((byte[])configUrl.getBytes(), (int)0);
        String timestampKey = configUrl + "_timestamp";
        BraintreeSharedPreferences.getSharedPreferences((Context)context).edit().putString(configUrl, configuration.toJson()).putLong(timestampKey, System.currentTimeMillis()).apply();
    }
}

