/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.DataCollector;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.models.CardBuilder;
import com.braintreepayments.api.models.PaymentMethodNonce;

public class Card {
    public static void tokenize(final BraintreeFragment fragment, CardBuilder cardBuilder) {
        TokenizationClient.tokenize(fragment, cardBuilder, new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                DataCollector.collectRiskData(fragment, paymentMethodNonce);
                fragment.postCallback(paymentMethodNonce);
                fragment.sendAnalyticsEvent("card.nonce-received");
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
                fragment.sendAnalyticsEvent("card.nonce-failed");
            }
        });
    }

    public static void tokenize(BraintreeFragment fragment, CardBuilder cardBuilder, PaymentMethodNonceCallback callback) {
        TokenizationClient.tokenize(fragment, cardBuilder, callback);
    }
}

