/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.util;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import java.util.Map;

public interface ExprFactory<K> {
    public Expression<K> not(Expression<K> var1);

    public Expression<K> and(Expression<K>[] var1);

    public Expression<K> or(Expression<K>[] var1);

    public static class Interning<K>
    implements ExprFactory<K> {
        private Map<Expression<K>, Expression<K>> values;

        public Interning(Map<Expression<K>, Expression<K>> internMap) {
            this.values = internMap;
        }

        private Expression<K> intern(Expression<K> expr) {
            if (this.values.containsKey(expr)) {
                return this.values.get(expr);
            }
            this.values.put(expr, expr);
            return expr;
        }

        @Override
        public Expression<K> not(Expression<K> child) {
            return this.intern(Not.of(child));
        }

        @Override
        public Expression<K> and(Expression<K>[] children) {
            return this.intern(And.of(children));
        }

        @Override
        public Expression<K> or(Expression<K>[] children) {
            return this.intern(Or.of(children));
        }
    }

    public static class Default<K>
    implements ExprFactory<K> {
        @Override
        public Expression<K> not(Expression<K> child) {
            return Not.of(child);
        }

        @Override
        public Expression<K> and(Expression<K>[] children) {
            return And.of(children);
        }

        @Override
        public Expression<K> or(Expression<K>[] children) {
            return Or.of(children);
        }
    }
}

