/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Variable;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.QuineMcCluskey;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;

public class RuleSet {
    private static final int QMC_CARDINALITY_CUTOFF = 8;

    public static <K> Expression<K> simplify(Expression<K> root) {
        return RuleSet.simplify(root, ExprOptions.noCaching());
    }

    public static <K> Expression<K> simplify(Expression<K> root, ExprOptions<K> options) {
        return RulesHelper.applySet(root, RulesHelper.simplifyRules(), options);
    }

    public static <K> Expression<K> toDNFViaQMC(Expression<K> root, ExprOptions<K> options) {
        HashSet variables = new HashSet();
        root.collectK(variables, 9);
        int varCount = variables.size();
        if (varCount <= 8 && varCount > 0) {
            return QuineMcCluskey.toDNF(root, options);
        }
        return RuleSet.toSop(root);
    }

    public static <K> Expression<K> toSop(Expression<K> root) {
        return RuleSet.toSop(root, ExprOptions.noCaching());
    }

    public static <K> Expression<K> toSop(Expression<K> root, ExprOptions<K> options) {
        root = root.map(options.getPreInternFunction(), options.getExprFactory());
        return RulesHelper.applySet(RulesHelper.applySet(root, RulesHelper.demorganRules(), options), RulesHelper.toSopRules(), options);
    }

    public static <K> Expression<K> toPos(Expression<K> root) {
        return RuleSet.toPos(root, ExprOptions.noCaching());
    }

    public static <K> Expression<K> toPos(Expression<K> root, ExprOptions<K> options) {
        Not<K> inverse = Not.of(root);
        Expression<K> sopInv = RuleSet.toSop(inverse, options);
        Not<K> inverse2 = Not.of(sopInv);
        return RulesHelper.applySet(inverse2, RulesHelper.demorganRules(), options);
    }

    public static <K> Expression<K> assign(Expression<K> root, Map<K, Boolean> values) {
        return RuleSet.assign(root, values, ExprOptions.noCaching());
    }

    public static <K> Expression<K> assign(Expression<K> root, Map<K, Boolean> values, ExprOptions<K> options) {
        root = root.map(new Assign<K>(values), options.getExprFactory());
        return RulesHelper.applyAll(root, RulesHelper.simplifyRules(), options);
    }

    public static <K> Expression<K> toDNF(Expression<K> root, ExprOptions<K> options) {
        return RuleSet.toSop(root, options);
    }

    public static <K> Expression<K> toDNF(Expression<K> root) {
        return RuleSet.toSop(root);
    }

    public static <K> Expression<K> toCNF(Expression<K> root, ExprOptions<K> options) {
        return RuleSet.toPos(root, options);
    }

    public static <K> Expression<K> toCNF(Expression<K> root) {
        return RuleSet.toPos(root, ExprOptions.noCaching());
    }

    static class Assign<K>
    implements Function<Expression<K>, Expression<K>> {
        private final Map<K, Boolean> values;

        public Assign(Map<K, Boolean> values) {
            this.values = values;
        }

        @Override
        public Expression<K> apply(Expression<K> kExpression) {
            Variable kVar;
            Object value;
            if (kExpression instanceof Variable && this.values.containsKey(value = (kVar = (Variable)kExpression).getValue())) {
                return Literal.of(this.values.get(value));
            }
            return kExpression;
        }
    }
}

