/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DistributiveLaw<K>
extends Rule<NExpression<K>, K> {
    @Override
    public Expression<K> applyInternal(NExpression<K> input, ExprOptions<K> options) {
        ExprFactory<K> factory = options.getExprFactory();
        if (input instanceof And) {
            return this.doApplyInternal(input, factory::or, factory::and);
        }
        if (input instanceof Or) {
            return this.doApplyInternal(input, factory::and, factory::or);
        }
        throw new IllegalArgumentException("Not supported input expression:" + input);
    }

    private Expression<K> doApplyInternal(NExpression<K> input, ExpressionCreator<K> upperExpressionCreator, ExpressionCreator<K> innerExpressionCreator) {
        Expression<K> commonExpression = this.findCommonExpression(input.getChildren()).orElseThrow(() -> new IllegalArgumentException("Common expression is not found in " + input));
        return (Expression)upperExpressionCreator.apply(new Expression[]{commonExpression, (Expression)innerExpressionCreator.apply(input.getChildren().stream().map(child -> this.excludeChild((Expression<K>)child, upperExpressionCreator, commonExpression)).toArray(Expression[]::new))});
    }

    private Expression<K> excludeChild(Expression<K> expression, ExpressionCreator<K> newExpressionCreator, Expression<K> childToExclude) {
        Expression[] leftChildren = (Expression[])expression.getChildren().stream().filter(child -> !childToExclude.equals(child)).toArray(Expression[]::new);
        if (leftChildren.length == 1) {
            return leftChildren[0];
        }
        return (Expression)newExpressionCreator.apply(leftChildren);
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        if (input == null) {
            return false;
        }
        if (input instanceof And) {
            return this.isApplicable(input, Or.class);
        }
        if (input instanceof Or) {
            return this.isApplicable(input, And.class);
        }
        return false;
    }

    private <C extends NExpression<?>> boolean isApplicable(Expression<K> input, Class<C> childClass) {
        List<Expression<K>> children = input.getChildren();
        if (children == null || children.size() < 2) {
            return false;
        }
        if (children.stream().anyMatch(child -> !childClass.isInstance(child))) {
            return false;
        }
        return this.findCommonExpression(children).isPresent();
    }

    private Optional<Expression<K>> findCommonExpression(List<Expression<K>> expressions) {
        return expressions.stream().skip(1L).reduce(expressions.get(0).getChildren(), (commons, expression) -> commons.stream().filter(element -> expression.getChildren().stream().anyMatch(element::equals)).collect(Collectors.toList()), (list1, list2) -> list1.stream().filter(element1 -> list1.stream().anyMatch(element1::equals)).collect(Collectors.toList())).stream().findFirst();
    }

    @FunctionalInterface
    private static interface ExpressionCreator<K>
    extends Function<Expression<K>[], Expression<K>> {
    }
}

