/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.cache;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.cache.RuleCache;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class UnboundedRuleCache<K>
implements RuleCache<K> {
    private final Map<Class<? extends Rule>, Map<Expression<K>, Expression<K>>> simplificatonCache;
    private final Function<Expression<K>, Expression<K>> interningFunction;

    public UnboundedRuleCache(Function<Expression<K>, Expression<K>> interningFunction) {
        this.interningFunction = interningFunction;
        this.simplificatonCache = new HashMap<Class<? extends Rule>, Map<Expression<K>, Expression<K>>>();
    }

    @Override
    public Expression<K> get(Class<? extends Rule> rule, Expression<K> input) {
        Map<Expression<K>, Expression<K>> forRule = this.simplificatonCache.get(rule);
        if (forRule != null) {
            return forRule.get(input);
        }
        return null;
    }

    @Override
    public void put(Class<? extends Rule> rule, Expression<K> input, Expression<K> output, ExprOptions<K> options) {
        ExprFactory<K> factory = options.getExprFactory();
        Expression<K> shrunkInput = input.map(this.interningFunction, factory);
        Expression<K> shrunkOutput = output.map(this.interningFunction, factory);
        if (!this.simplificatonCache.containsKey(rule)) {
            this.simplificatonCache.put(rule, new HashMap());
        }
        Map<Expression<Expression<K>>, Expression<Expression<K>>> ruleCache = this.simplificatonCache.get(rule);
        ruleCache.put(shrunkInput, shrunkOutput);
    }
}

