/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.RuleList;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class Variable<K>
extends Expression<K> {
    public static final String EXPR_TYPE = "variable";
    private final K value;

    private Variable(K value) {
        this.value = value;
    }

    public K getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Expression<K> apply(RuleList<K> rules, ExprOptions<K> options) {
        return this;
    }

    @Override
    public List<Expression<K>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Expression<K> map(Function<Expression<K>, Expression<K>> function, ExprFactory<K> factory) {
        return function.apply(this);
    }

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        return this;
    }

    public static <K> Variable<K> of(K value) {
        return new Variable<K>(value);
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.value, variable.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public void collectK(Set<K> set, int limit) {
        if (set.size() >= limit) {
            return;
        }
        set.add(this.value);
    }

    @Override
    public Expression<K> replaceVars(Map<K, Expression<K>> m, ExprFactory<K> factory) {
        if (m.containsKey(this.getValue())) {
            return m.get(this.getValue());
        }
        return this;
    }
}

