/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.RuleList;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class Expression<K>
implements Serializable {
    public static final Comparator<Expression> HASH_COMPARATOR = new HashComparator();
    public static final Comparator<Expression> LEXICOGRAPHIC_COMPARATOR = new LexicographicComparator();
    private transient Set<K> k = null;

    public abstract Expression<K> apply(RuleList<K> var1, ExprOptions<K> var2);

    public abstract List<Expression<K>> getChildren();

    public abstract Expression<K> map(Function<Expression<K>, Expression<K>> var1, ExprFactory<K> var2);

    public abstract String getExprType();

    public abstract Expression<K> sort(Comparator<Expression> var1);

    public String toLexicographicString() {
        return this.sort(LEXICOGRAPHIC_COMPARATOR).toString();
    }

    public Set<K> getAllK() {
        if (this.k != null) {
            return this.k;
        }
        HashSet<K> variables = new HashSet<K>();
        this.collectK(variables, Integer.MAX_VALUE);
        this.k = variables;
        return variables;
    }

    public abstract void collectK(Set<K> var1, int var2);

    public abstract Expression<K> replaceVars(Map<K, Expression<K>> var1, ExprFactory<K> var2);

    public static class LexicographicComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    public static class HashComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            if (o1 == o2) {
                return 0;
            }
            int compare = Integer.compare(o1.hashCode(), o2.hashCode());
            if (compare == 0 && !o1.equals(o2)) {
                return LEXICOGRAPHIC_COMPARATOR.compare(o1, o2);
            }
            return compare;
        }
    }
}

