/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.RuleList;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class And<K>
extends NExpression<K> {
    public static final String EXPR_TYPE = "and";
    private String cachedStringRepresentation = null;

    public static <K> And<K> of(Expression<K>[] children, Comparator<Expression> comparator) {
        return new And<K>(children, comparator);
    }

    private And(Expression<K>[] children, Comparator<Expression> comparator) {
        super(children, 1483, comparator);
    }

    public String toString() {
        if (this.cachedStringRepresentation == null) {
            this.cachedStringRepresentation = Arrays.stream(this.expressions).map(Object::toString).collect(Collectors.joining(" & ", "(", ")"));
        }
        return this.cachedStringRepresentation;
    }

    @Override
    public Expression<K> apply(RuleList<K> rules, ExprOptions<K> options) {
        int i;
        Expression[] children = null;
        boolean modified = false;
        for (i = 0; i < this.expressions.length; ++i) {
            Expression<K> newChild = RulesHelper.applyAll(this.expressions[i], rules, options);
            if (newChild == this.expressions[i]) continue;
            modified = true;
            if (children == null) {
                children = new Expression[this.expressions.length];
            }
            children[i] = newChild;
        }
        if (!modified) {
            return this;
        }
        for (i = 0; i < this.expressions.length; ++i) {
            if (children[i] != null) continue;
            children[i] = this.expressions[i];
        }
        return options.getExprFactory().and(children);
    }

    @Override
    public Expression<K> map(Function<Expression<K>, Expression<K>> function, ExprFactory<K> factory) {
        int i;
        Expression[] children = null;
        boolean modified = false;
        for (i = 0; i < this.expressions.length; ++i) {
            Expression<K> newChild = this.expressions[i].map(function, factory);
            if (newChild == this.expressions[i]) continue;
            modified = true;
            if (children == null) {
                children = new Expression[this.expressions.length];
            }
            children[i] = newChild;
        }
        if (!modified) {
            return function.apply(this);
        }
        for (i = 0; i < this.expressions.length; ++i) {
            if (children[i] != null) continue;
            children[i] = this.expressions[i];
        }
        return function.apply(factory.and(children));
    }

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        Expression[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            children[i] = this.expressions[i].sort(comparator);
        }
        return And.of(children, comparator);
    }

    public static <K> And<K> of(Expression<K> child1, Expression<K> child2, Expression<K> child3) {
        return And.of(ExprUtil.list(child1, child2, child3));
    }

    public static <K> And<K> of(Expression<K> child1, Expression<K> child2) {
        return And.of(ExprUtil.list(child1, child2));
    }

    @SafeVarargs
    public static <K> And<K> of(Expression<K> ... children) {
        return new And<K>(children, HASH_COMPARATOR);
    }

    public static <K> And<K> of(Expression<K> child1) {
        return And.of(ExprUtil.list(child1));
    }

    public static <K> And<K> of(List<? extends Expression<K>> children) {
        return new And<K>(children.toArray(new Expression[children.size()]), HASH_COMPARATOR);
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    @Override
    public Expression<K> replaceVars(Map<K, Expression<K>> m, ExprFactory<K> factory) {
        Expression[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            children[i] = this.expressions[i].replaceVars(m, factory);
        }
        return factory.and(children);
    }
}

