/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.eval;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.eval.EvalAnd;
import com.bpodgursky.jbool_expressions.eval.EvalLiteral;
import com.bpodgursky.jbool_expressions.eval.EvalNot;
import com.bpodgursky.jbool_expressions.eval.EvalOr;
import com.bpodgursky.jbool_expressions.eval.EvalRule;
import com.bpodgursky.jbool_expressions.eval.EvalVariable;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalEngine {
    public static <K> Map<String, EvalRule<K>> booleanRules() {
        HashMap rules = Maps.newHashMap();
        rules.put("and", new EvalAnd());
        rules.put("or", new EvalOr());
        rules.put("not", new EvalNot());
        rules.put("literal", new EvalLiteral());
        return rules;
    }

    public static <K> boolean evaluateBoolean(Expression<K> expr, Map<K, Boolean> values) {
        Map<String, EvalRule<String>> rules = EvalEngine.booleanRules();
        rules.put("variable", new EvalVariable<K>(values));
        return EvalEngine.evaluate(expr, rules);
    }

    public static <K> boolean evaluate(Expression<K> expr, Map<String, EvalRule<K>> rules) {
        return EvalRule.evaluateInternal(expr, rules);
    }
}

