/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Variable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprUtil {
    public static <K> Expression<K>[] allExceptMatch(Expression<K>[] exprs, Expression<K> omit) {
        HashSet<Expression<K>> andTerms = new HashSet<Expression<K>>();
        for (Expression<K> expression : exprs) {
            if (expression.equals(omit)) continue;
            andTerms.add(expression);
        }
        int i = 0;
        Expression<K>[] result = ExprUtil.expr(andTerms.size());
        for (Expression expression : andTerms) {
            result[i++] = expression;
        }
        return result;
    }

    public static <K> Expression<K>[] expr(int length) {
        return new Expression[length];
    }

    public static <K> void addAll(Collection<Expression<K>> set, Expression<K>[] values) {
        Collections.addAll(set, values);
    }

    public static <K> List<Expression<K>> list(Expression ... exprs) {
        return Arrays.asList(exprs);
    }

    public static <K> Set<K> getVariables(Expression<K> expr) {
        if (expr instanceof Variable) {
            return Collections.singleton(((Variable)expr).getValue());
        }
        if (expr instanceof Not) {
            return ExprUtil.getVariables(((Not)expr).getE());
        }
        if (expr instanceof NExpression) {
            HashSet vars = new HashSet();
            for (Expression child : ((NExpression)expr).expressions) {
                vars.addAll(ExprUtil.getVariables(child));
            }
            return vars;
        }
        return Collections.emptySet();
    }
}

