/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.rules.Rule;
import java.util.ArrayList;

public class SimplifyOr<K>
extends Rule<Or<K>, K> {
    @Override
    public Expression<K> applyInternal(Or<K> input) {
        for (Expression expr : input.expressions) {
            if (expr instanceof Literal) {
                Literal l = (Literal)expr;
                if (!l.getValue()) {
                    return this.copyWithoutFalse(input);
                }
                return Literal.of(true);
            }
            if (!(expr instanceof Not)) continue;
            Expression notChild = ((Not)expr).getE();
            for (Expression child : input.expressions) {
                if (!child.equals(notChild)) continue;
                return Literal.getTrue();
            }
        }
        return input;
    }

    private Expression<K> copyWithoutFalse(Or<K> input) {
        ArrayList<Expression> copy = new ArrayList<Expression>();
        for (Expression expr : input.expressions) {
            Literal l;
            if (expr instanceof Literal && !(l = (Literal)expr).getValue()) continue;
            copy.add(expr);
        }
        if (copy.isEmpty()) {
            return Literal.of(false);
        }
        return Or.of(copy);
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof Or;
    }
}

