/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import com.bpodgursky.jbool_expressions.eval.EvalEngine;
import com.bpodgursky.jbool_expressions.rules.RuleSet;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class QuineMcCluskey {
    public static <K> Expression<K> toDNF(Expression<K> input) {
        ArrayList<K> variables = new ArrayList<K>(input.getAllK());
        Collections.reverse(variables);
        List<Integer> minterms = QuineMcCluskey.findMinterms(0, variables, new HashMap(), input);
        if ((double)minterms.size() == Math.pow(2.0, variables.size())) {
            return Literal.getTrue();
        }
        Set<Implicant> mergedImplicants = QuineMcCluskey.getMergedImplicants(minterms);
        EPICalculation essentialPrimeImplicants = QuineMcCluskey.getEssentialPrimeImplicants(mergedImplicants, minterms);
        ArrayList<Expression<K>> orChildren = new ArrayList<Expression<K>>();
        for (Implicant epi : essentialPrimeImplicants.epis) {
            orChildren.add(QuineMcCluskey.toExpr(epi, variables));
        }
        if (!essentialPrimeImplicants.uncoveredMinterms.isEmpty()) {
            orChildren.addAll(QuineMcCluskey.getPetrickMethodImplicants(variables, essentialPrimeImplicants.uncoveredMinterms, new ArrayList<Implicant>(essentialPrimeImplicants.nonEpis)));
        }
        if (orChildren.isEmpty()) {
            return Literal.getFalse();
        }
        return RuleSet.simplify(Or.of(orChildren));
    }

    public static EPICalculation getEssentialPrimeImplicants(Set<Implicant> implicants, List<Integer> minterms) {
        HashSet<Implicant> epis = new HashSet<Implicant>();
        HashSet<Implicant> nonEPIs = new HashSet<Implicant>(implicants);
        ArrayList<Integer> uncoveredMinterms = new ArrayList<Integer>();
        for (Integer minterm : minterms) {
            List coveringImplicants = implicants.stream().filter(implicant -> QuineMcCluskey.covers(minterm, implicant)).collect(Collectors.toList());
            if (coveringImplicants.size() == 1) {
                Implicant implicant2 = (Implicant)coveringImplicants.get(0);
                epis.add(implicant2);
                nonEPIs.remove(implicant2);
                continue;
            }
            uncoveredMinterms.add(minterm);
        }
        LinkedList<Integer> remainingMinterms = new LinkedList<Integer>();
        for (Integer uncoveredMinterm : uncoveredMinterms) {
            boolean coveredByEPIs = false;
            for (Implicant epi : epis) {
                if (!QuineMcCluskey.covers(uncoveredMinterm, epi)) continue;
                coveredByEPIs = true;
                break;
            }
            if (coveredByEPIs) continue;
            remainingMinterms.add(uncoveredMinterm);
        }
        return new EPICalculation(epis, nonEPIs, remainingMinterms);
    }

    private static boolean covers(Integer minterm, Implicant implicant) {
        return (implicant.base ^ minterm & ~implicant.dontCare) == 0;
    }

    protected static <K> List<Expression<K>> getPetrickMethodImplicants(List<K> variables, List<Integer> remainingMinterms, List<Implicant> implicants) {
        int i = 0;
        HashMap<Implicant, Integer> implicantMap = new HashMap<Implicant, Integer>();
        HashMap<Integer, Implicant> implicantMapInv = new HashMap<Integer, Implicant>();
        for (Implicant implicant : implicants) {
            int inc = i++;
            implicantMap.put(implicant, inc);
            implicantMapInv.put(inc, implicant);
        }
        ArrayList products = new ArrayList();
        for (Integer remainingMinterm : remainingMinterms) {
            ArrayList coveringImplicants = new ArrayList();
            for (Implicant implicant : implicants) {
                if (!QuineMcCluskey.covers(remainingMinterm, implicant)) continue;
                coveringImplicants.add(Variable.of(implicantMap.get(implicant)));
            }
            products.add(Or.of(coveringImplicants));
        }
        And and = And.of(products);
        Expression asSop = RulesHelper.applySet(and, RulesHelper.toSopRules());
        Or root = (Or)asSop;
        int smallestTerms = Integer.MAX_VALUE;
        Expression bestTerm = null;
        for (Expression child : root.getChildren()) {
            HashSet<K> allVars = new HashSet<K>();
            for (Integer implicantNum : child.getAllK()) {
                Implicant implicant = (Implicant)implicantMapInv.get(implicantNum);
                Expression<K> expr = QuineMcCluskey.toExpr(implicant, variables);
                allVars.addAll(expr.getAllK());
            }
            if (allVars.size() >= smallestTerms) continue;
            bestTerm = child;
            smallestTerms = allVars.size();
        }
        ArrayList<Expression<K>> returnOrs = new ArrayList<Expression<K>>();
        if (bestTerm instanceof Variable) {
            Variable var = (Variable)bestTerm;
            returnOrs.add(QuineMcCluskey.toExpr((Implicant)implicantMapInv.get(var.getValue()), variables));
        } else {
            And bestAnd = (And)bestTerm;
            for (Expression child : bestAnd.getChildren()) {
                Variable var = (Variable)child;
                returnOrs.add(QuineMcCluskey.toExpr((Implicant)implicantMapInv.get(var.getValue()), variables));
            }
        }
        return returnOrs;
    }

    private static <K> Expression<K> toExpr(Implicant implicant, List<K> variables) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        for (int i = 0; i < variables.size(); ++i) {
            boolean dontcare;
            boolean val = (implicant.base & 1 << i) != 0;
            boolean bl = dontcare = (implicant.dontCare & 1 << i) != 0;
            if (dontcare) continue;
            if (val) {
                children.add(Variable.of(variables.get(i)));
                continue;
            }
            children.add(Not.of(Variable.of(variables.get(i))));
        }
        return And.of(children);
    }

    private static Set<Implicant> getImplicants(Integer numOnes, Integer sizeN, Map<Integer, Map<Integer, Set<Implicant>>> implicants) {
        Map<Integer, Set<Implicant>> oneMores;
        if (implicants.containsKey(numOnes) && (oneMores = implicants.get(numOnes)).containsKey(sizeN)) {
            return oneMores.get(sizeN);
        }
        return Collections.emptySet();
    }

    protected static Set<Implicant> getMergedImplicants(List<Integer> minterms) {
        Map<Integer, Map<Integer, Set<Implicant>>> implicants = QuineMcCluskey.groupMinterms(minterms);
        int sizeN = 1;
        while (true) {
            boolean mergedAnything = false;
            for (Integer n : implicants.keySet()) {
                HashSet<Implicant> newImplicants = new HashSet<Implicant>();
                for (Implicant implicant : QuineMcCluskey.getImplicants(n, sizeN, implicants)) {
                    for (Implicant potentialJoin : QuineMcCluskey.getImplicants(n + 1, sizeN, implicants)) {
                        int difference;
                        if (implicant.dontCare != potentialJoin.dontCare || QuineMcCluskey.numberOfSetBits(difference = implicant.base ^ potentialJoin.base) != 1) continue;
                        implicant.merged = true;
                        potentialJoin.merged = true;
                        newImplicants.add(new Implicant(implicant.base & ~difference, implicant.dontCare | difference));
                    }
                }
                if (newImplicants.isEmpty()) continue;
                mergedAnything = true;
                implicants.get(n).put(sizeN * 2, newImplicants);
            }
            if (!mergedAnything) break;
            sizeN *= 2;
        }
        HashSet<Implicant> unmerged = new HashSet<Implicant>();
        for (Map.Entry entry : implicants.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                for (Implicant implicant : (Set)entry2.getValue()) {
                    if (implicant.merged) continue;
                    unmerged.add(implicant);
                }
            }
        }
        return unmerged;
    }

    private static Map<Integer, Map<Integer, Set<Implicant>>> groupMinterms(List<Integer> minterms) {
        HashMap mintermsByOnes = new HashMap();
        for (Integer minterm : minterms) {
            int bits = QuineMcCluskey.numberOfSetBits(minterm);
            if (!mintermsByOnes.containsKey(bits)) {
                mintermsByOnes.put(bits, new ArrayList());
            }
            ((List)mintermsByOnes.get(bits)).add(minterm);
        }
        HashMap<Integer, Map<Integer, Set<Implicant>>> numOnesToNumImplicantsToImplicants = new HashMap<Integer, Map<Integer, Set<Implicant>>>();
        for (Map.Entry entry : mintermsByOnes.entrySet()) {
            HashSet<Implicant> implicants = new HashSet<Implicant>();
            for (Integer minTerm : (List)entry.getValue()) {
                implicants.add(new Implicant(minTerm, 0));
            }
            numOnesToNumImplicantsToImplicants.put((Integer)entry.getKey(), new HashMap(Collections.singletonMap(1, implicants)));
        }
        return numOnesToNumImplicantsToImplicants;
    }

    private static int numberOfSetBits(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        return (i + (i >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24;
    }

    public static <K> List<Integer> findMinterms(int pos, ArrayList<K> variables, Map<K, Boolean> assignments, Expression<K> input) {
        if (pos == variables.size()) {
            boolean val = EvalEngine.evaluateBoolean(input, assignments);
            if (val) {
                int minTerm = 0;
                for (int i = 0; i < variables.size(); ++i) {
                    if (!assignments.get(variables.get(i)).booleanValue()) continue;
                    minTerm |= 1 << i;
                }
                return Collections.singletonList(minTerm);
            }
            return Collections.emptyList();
        }
        assignments.put(variables.get(pos), true);
        ArrayList<Integer> minterms = new ArrayList<Integer>(QuineMcCluskey.findMinterms(pos + 1, variables, assignments, input));
        assignments.put(variables.get(pos), false);
        minterms.addAll(QuineMcCluskey.findMinterms(pos + 1, variables, assignments, input));
        return minterms;
    }

    public static class EPICalculation {
        private final Set<Implicant> epis;
        private final Set<Implicant> nonEpis;
        private final List<Integer> uncoveredMinterms;

        private EPICalculation(Set<Implicant> epis, Set<Implicant> nonEPIs, List<Integer> uncoveredMinterms) {
            this.epis = epis;
            this.nonEpis = nonEPIs;
            this.uncoveredMinterms = uncoveredMinterms;
        }

        public Set<Implicant> getEpis() {
            return this.epis;
        }

        public List<Integer> getUncoveredMinterms() {
            return this.uncoveredMinterms;
        }
    }

    public static class Implicant {
        private final int base;
        private final int dontCare;
        boolean merged;

        public Implicant(int base, int dontCare) {
            this.base = base;
            this.dontCare = dontCare;
        }

        public String toString() {
            return "Implicant{base=" + this.base + ", dontCare=" + this.dontCare + ", merged=" + this.merged + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Implicant implicant = (Implicant)o;
            return this.base == implicant.base && this.dontCare == implicant.dontCare && this.merged == implicant.merged;
        }

        public int hashCode() {
            return Objects.hash(this.base, this.dontCare, this.merged);
        }
    }
}

