/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import com.bpodgursky.jbool_expressions.rules.RuleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExprUtil {
    public static <K> Expression<K> collapseToSOP(And<K> and, Or<K> internalOr, Expression<K> omitFromOr) {
        Expression<K>[] childrenNew = ExprUtil.allExceptMatch(and.expressions, internalOr);
        ArrayList<And<K>> newChildren = new ArrayList<And<K>>();
        for (Expression orChild : internalOr.expressions) {
            if (orChild.equals(omitFromOr)) continue;
            ArrayList<Expression<K>> andOthers = new ArrayList<Expression<K>>();
            ExprUtil.addAll(andOthers, childrenNew);
            andOthers.add(orChild);
            newChildren.add(And.of(andOthers));
        }
        return Or.of(newChildren);
    }

    public static <K> Expression<K> stripNegation(And<K> and, Or<K> internalOr, Expression<K> omitFromOr) {
        Expression<K>[] childrenNew = ExprUtil.allExceptMatch(and.expressions, internalOr);
        ArrayList<Expression<K>> newChildren = new ArrayList<Expression<K>>(Arrays.asList(childrenNew));
        ArrayList<Expression> orOthers = new ArrayList<Expression>();
        for (Expression orChild : internalOr.expressions) {
            if (orChild.equals(omitFromOr)) continue;
            orOthers.add(orChild);
        }
        newChildren.add(Or.of(orOthers));
        return And.of(newChildren);
    }

    public static <K> Expression<K> stripNegation(Or<K> or, And<K> internalAnd, Expression<K> omitFromAnd) {
        Expression<K>[] childrenNew = ExprUtil.allExceptMatch(or.expressions, internalAnd);
        ArrayList<Expression<K>> newChildren = new ArrayList<Expression<K>>(Arrays.asList(childrenNew));
        ArrayList<Expression> andOthers = new ArrayList<Expression>();
        for (Expression andChild : internalAnd.expressions) {
            if (andChild.equals(omitFromAnd)) continue;
            andOthers.add(andChild);
        }
        newChildren.add(And.of(andOthers));
        return Or.of(newChildren);
    }

    public static <K> Expression<K>[] allExceptMatch(Collection<Expression<K>> exprs, Set<? extends Expression<K>> omit) {
        LinkedHashSet<Expression<K>> andTerms = new LinkedHashSet<Expression<K>>();
        for (Expression<K> eachExpr : exprs) {
            if (omit.contains(eachExpr)) continue;
            andTerms.add(eachExpr);
        }
        return ExprUtil.toArray(andTerms);
    }

    public static <K> Expression<K>[] allExceptMatch(List<Expression<K>> exprs, Expression<K> omit) {
        return ExprUtil.allExceptMatch(exprs.toArray(new Expression[exprs.size()]), omit);
    }

    public static <K> Expression<K>[] allExceptMatch(Expression<K>[] exprs, Expression<K> omit) {
        LinkedHashSet<Expression<K>> andTerms = new LinkedHashSet<Expression<K>>();
        for (Expression<K> eachExpr : exprs) {
            if (eachExpr.equals(omit)) continue;
            andTerms.add(eachExpr);
        }
        return ExprUtil.toArray(andTerms);
    }

    private static <K> Expression<K>[] toArray(Set<Expression<K>> andTerms) {
        int i = 0;
        Expression<K>[] result = ExprUtil.expr(andTerms.size());
        for (Expression<K> expr : andTerms) {
            result[i++] = expr;
        }
        return result;
    }

    public static <K> Expression<K>[] expr(int length) {
        return new Expression[length];
    }

    public static <K> void addAll(Collection<Expression<K>> set, Expression<K>[] values) {
        Collections.addAll(set, values);
    }

    public static <K> List<Expression<K>> list(Expression ... exprs) {
        return Arrays.asList(exprs);
    }

    public static <K> Set<K> getVariables(Expression<K> expr) {
        if (expr instanceof Variable) {
            return Collections.singleton(((Variable)expr).getValue());
        }
        if (expr instanceof Not) {
            return ExprUtil.getVariables(((Not)expr).getE());
        }
        if (expr instanceof NExpression) {
            LinkedHashSet vars = new LinkedHashSet();
            for (Expression child : ((NExpression)expr).expressions) {
                vars.addAll(ExprUtil.getVariables(child));
            }
            return vars;
        }
        return Collections.emptySet();
    }

    public static <K> List<K> getConstraintsByWeight(Expression<K> expression) {
        HashMap<K, Integer> simplificationWeights = new HashMap<K, Integer>();
        for (K variable : expression.getAllK()) {
            simplificationWeights.put(variable, Math.min(RuleSet.assign(expression, Collections.singletonMap(variable, true)).getAllK().size(), RuleSet.assign(expression, Collections.singletonMap(variable, false)).getAllK().size()));
        }
        return simplificationWeights.entrySet().stream().sorted((o1, o2) -> {
            int val = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (val != 0) {
                return val;
            }
            return o1.getKey().toString().compareTo(o2.getKey().toString());
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

