/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.rules.Rule;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Variable<K>
extends Expression<K> {
    public static final String EXPR_TYPE = "variable";
    private final K value;

    private Variable(K value) {
        this.value = value;
    }

    public K getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Expression<K> apply(List<Rule<?, K>> rules) {
        return this;
    }

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        return this;
    }

    public static <K> Variable<K> of(K value) {
        return new Variable<K>(value);
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.value, variable.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public Set<K> getAllK() {
        return Collections.singleton(this.value);
    }

    @Override
    public Expression<K> replaceVars(Map<K, Expression<K>> m) {
        if (m.containsKey(this.getValue())) {
            return m.get(this.getValue());
        }
        return this;
    }
}

