/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class NExpression<K>
extends Expression<K> {
    public final Expression<K>[] expressions;
    private int hashCode;

    protected NExpression(Expression<K>[] expressions, int seed, Comparator<Expression> sort) {
        if (expressions.length == 0) {
            throw new IllegalArgumentException("Arguments length 0!");
        }
        this.expressions = Arrays.copyOf(expressions, expressions.length);
        Arrays.sort(this.expressions, sort);
        this.hashCode = Objects.hash(seed, Arrays.hashCode(this.expressions));
    }

    @Override
    public Expression<K> apply(List<Rule<?, K>> rules) {
        Expression[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            children[i] = RulesHelper.applyAll(this.expressions[i], rules);
        }
        return this.create(children);
    }

    public List<Expression<K>> getChildren() {
        return ExprUtil.list(this.expressions);
    }

    public NExpression<K> create(Expression<K>[] children) {
        return this.create(children, HASH_COMPARATOR);
    }

    protected abstract NExpression<K> create(Expression<K>[] var1, Comparator<Expression> var2);

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        Expression[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            children[i] = this.expressions[i].sort(comparator);
        }
        return this.create(children, comparator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NExpression that = (NExpression)o;
        return this.hashCode == that.hashCode && Arrays.equals(this.expressions, that.expressions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Set<K> getAllK() {
        return Arrays.stream(this.expressions).map(Expression::getAllK).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

