/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.rules.Rule;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Literal<K>
extends Expression<K> {
    public static final String EXPR_TYPE = "literal";
    private final boolean value;
    private static final Literal TRUE = new Literal(true);
    private static final Literal FALSE = new Literal(false);

    public static <V> Literal<V> getTrue() {
        return TRUE;
    }

    public static <V> Literal<V> getFalse() {
        return FALSE;
    }

    public static <K> Literal<K> of(boolean value) {
        if (value) {
            return Literal.getTrue();
        }
        return Literal.getFalse();
    }

    private Literal(boolean value) {
        this.value = value;
    }

    public String toString() {
        return Boolean.valueOf(this.value).toString();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public Expression<K> apply(List<Rule<?, K>> rules) {
        return this;
    }

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        return this;
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public Set<K> getAllK() {
        return new HashSet();
    }

    @Override
    public Expression<K> replaceVars(Map<K, Expression<K>> m) {
        return this;
    }
}

