/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class And<K>
extends NExpression<K> {
    public static final String EXPR_TYPE = "and";
    private Optional<String> cachedStringRepresentation = Optional.empty();

    public static <K> And<K> of(Expression<K>[] children, Comparator<Expression> comparator) {
        return new And<K>(children, comparator);
    }

    private And(Expression<K>[] children, Comparator<Expression> comparator) {
        super(children, 1483, comparator);
    }

    @Override
    public NExpression<K> create(Expression<K>[] children, Comparator<Expression> comparator) {
        return And.of(children, comparator);
    }

    public String toString() {
        if (!this.cachedStringRepresentation.isPresent()) {
            this.cachedStringRepresentation = Optional.of(Arrays.stream(this.expressions).map(Object::toString).collect(Collectors.joining(" & ", "(", ")")));
        }
        return this.cachedStringRepresentation.get();
    }

    public static <K> And<K> of(Expression<K> child1, Expression<K> child2, Expression<K> child3) {
        return And.of(ExprUtil.list(child1, child2, child3));
    }

    public static <K> And<K> of(Expression<K> child1, Expression<K> child2) {
        return And.of(ExprUtil.list(child1, child2));
    }

    @SafeVarargs
    public static <K> And<K> of(Expression<K> ... children) {
        return new And<K>(children, HASH_COMPARATOR);
    }

    public static <K> And<K> of(Expression<K> child1) {
        return And.of(ExprUtil.list(child1));
    }

    public static <K> And<K> of(List<? extends Expression<K>> children) {
        return new And<K>(children.toArray(new Expression[children.size()]), HASH_COMPARATOR);
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    @Override
    public Expression<K> replaceVars(Map<K, Expression<K>> m) {
        Expression[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            children[i] = this.expressions[i].replaceVars(m);
        }
        return And.of(children);
    }
}

