/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.rules.Rule;
import java.util.Comparator;
import java.util.List;

public abstract class Expression<K> {
    public static final Comparator<Expression> HASH_COMPARATOR = new HashComparator();
    public static final Comparator<Expression> LEXICOGRAPHIC_COMPARATOR = new LexicographicComparator();

    public abstract Expression<K> apply(List<Rule<?, K>> var1);

    public abstract String getExprType();

    protected abstract Expression<K> sort(Comparator<Expression> var1);

    public String toLexicographicString() {
        return this.sort(LEXICOGRAPHIC_COMPARATOR).toString();
    }

    public static class LexicographicComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    public static class HashComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            if (o1 == o2) {
                return 0;
            }
            int compare = Integer.compare(o1.hashCode(), o2.hashCode());
            if (compare == 0 && !o1.equals(o2)) {
                return LEXICOGRAPHIC_COMPARATOR.compare(o1, o2);
            }
            return compare;
        }
    }
}

