/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.benchmark;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class GenerateExpressionExamples {
    public static void main(String[] args) throws IOException {
        GenerateExpressionExamples.generateExpressionsFile("datasets", 1, 5, 2, 10, 6);
    }

    private static void generateExpressionsFile(String outputDir, int variablePrefixLength, int numVariables, int minExprLength, int maxExprLength, int maxDepth) throws IOException {
        Random rand = new Random();
        new File(outputDir).mkdirs();
        ArrayList variables = Lists.newArrayList();
        String prefix = StringUtils.join(Collections.nCopies(variablePrefixLength, "X"), (String)"");
        for (int i = 0; i < numVariables; ++i) {
            variables.add(prefix + i);
        }
        File output = new File("datasets/expressions_" + variablePrefixLength + "_" + numVariables + "_" + minExprLength + "_" + maxExprLength + "_" + maxDepth + ".txt");
        FileWriter writer = new FileWriter(output);
        for (int i = 0; i < 50000; ++i) {
            Expression<String> expr = GenerateExpressionExamples.recurse(rand, variables, minExprLength, maxExprLength, 0, maxDepth);
            writer.write(expr.toString() + "\n");
        }
        writer.close();
    }

    private static Expression<String> recurse(Random rand, ArrayList<String> variables, int minExprLength, int maxExprLength, int depth, int maxDepth) {
        int next = depth == 0 ? rand.nextInt(3) : (depth == maxDepth ? 3 : rand.nextInt(4));
        if (next == 0 || next == 1) {
            ArrayList terms = Lists.newArrayList();
            for (int i = 0; i < minExprLength + rand.nextInt(maxExprLength - minExprLength); ++i) {
                terms.add(GenerateExpressionExamples.recurse(rand, variables, minExprLength, maxExprLength, depth + 1, maxDepth));
            }
            if (next == 0) {
                return And.of(terms);
            }
            return Or.of(terms);
        }
        if (next == 2) {
            return Not.of(GenerateExpressionExamples.recurse(rand, variables, minExprLength, maxExprLength, depth + 1, maxDepth));
        }
        if (next == 3) {
            return Variable.of(variables.get(rand.nextInt(variables.size())));
        }
        throw new IllegalArgumentException();
    }
}

