/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractCommon<K>
extends Rule<NExpression<K>, K> {
    private boolean oppositeNExpr(NExpression<K> first, Expression<K> second) {
        if (first instanceof And) {
            return second instanceof Or;
        }
        if (first instanceof Or) {
            return second instanceof And;
        }
        throw new RuntimeException();
    }

    private NExpression<K> ofSame(NExpression<K> first, List<? extends Expression<K>> others) {
        return first.create(others);
    }

    private NExpression<K> ofOpposite(NExpression<K> first, List<? extends Expression<K>> others) {
        if (first instanceof And) {
            return Or.of(others);
        }
        if (first instanceof Or) {
            return And.of(others);
        }
        throw new RuntimeException();
    }

    @Override
    public Expression<K> applyInternal(NExpression<K> input) {
        HashMultimap byParent = HashMultimap.create();
        for (Expression<Object> expression : input.getChildren()) {
            if (!this.oppositeNExpr(input, expression)) continue;
            NExpression inner = (NExpression)expression;
            for (Expression expression2 : inner.getChildren()) {
                byParent.put(expression2, (Object)inner);
            }
        }
        for (Expression<Object> expression : byParent.keySet()) {
            Set common = byParent.get(expression);
            if (common.size() <= 1) continue;
            ArrayList remainder = Lists.newArrayList();
            for (NExpression subExpr : common) {
                Object[] remaining = ExprUtil.allExceptMatch(subExpr.getChildren(), expression);
                remainder.add(subExpr.create(Lists.newArrayList((Object[])remaining)));
            }
            ArrayList arrayList = Lists.newArrayList((Object[])ExprUtil.allExceptMatch(input.getChildren(), common));
            arrayList.add(this.ofOpposite(input, Lists.newArrayList((Object[])new Expression[]{expression, this.ofSame(input, remainder)})));
            if (arrayList.size() > 1) {
                return this.ofSame(input, arrayList);
            }
            return (Expression)arrayList.get(0);
        }
        return input;
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof NExpression;
    }
}

