/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.example;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.PrefixParser;
import com.bpodgursky.jbool_expressions.Variable;
import com.bpodgursky.jbool_expressions.rules.RuleSet;
import java.util.Collections;

public class ExampleRunner {
    public static void main(String[] args) {
        And<String> expr = And.of(Variable.of("A"), Variable.of("B"), Or.of(Variable.of("C"), Not.of(Variable.of("C"))));
        System.out.println(expr);
        Expression<String> simplified = RuleSet.simplify(expr);
        System.out.println(simplified);
        Expression<String> halfAssigned = RuleSet.assign(simplified, Collections.singletonMap("A", true));
        System.out.println(halfAssigned);
        Expression<String> resolved = RuleSet.assign(halfAssigned, Collections.singletonMap("B", true));
        System.out.println(resolved);
        System.out.println(expr);
        Expression<String> parsedExpression = PrefixParser.parse("(* (+ (! C) C) A B)");
        System.out.println(parsedExpression);
        System.out.println(parsedExpression.equals(expr));
        Expression<String> nonStandard = PrefixParser.parse("(* (+ A B) (+ C D))");
        System.out.println(nonStandard);
        Expression<String> sopForm = RuleSet.toSop(nonStandard);
        System.out.println(sopForm);
    }
}

