/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixParser {
    private static final Pattern WHITESPACE = Pattern.compile("(\\s+).*", 32);
    private static final Pattern VARIABLE = Pattern.compile("([A-Z]+).*", 32);
    private static final Pattern TRUE = Pattern.compile("(true).*", 32);
    private static final Pattern FALSE = Pattern.compile("(false).*", 32);
    private static final Pattern NOT = Pattern.compile("(!).*", 32);
    private static final Pattern OR = Pattern.compile("(\\+).*", 32);
    private static final Pattern AND = Pattern.compile("(\\*).*", 32);
    private static final List<Pattern> TOKENS = Arrays.asList(VARIABLE, TRUE, FALSE, NOT, AND, OR);

    public static LinkedList<String> tokenize(String expr) {
        LinkedList parts = Lists.newLinkedList();
        int i = 0;
        while (i < expr.length()) {
            int iBefore = i;
            String remaining = expr.substring(i);
            Matcher whitespace = WHITESPACE.matcher(remaining);
            if (whitespace.matches()) {
                i += whitespace.group(1).length();
            }
            for (Pattern p : TOKENS) {
                Matcher var = p.matcher(remaining);
                if (!var.matches()) continue;
                String variable = var.group(1);
                parts.add(variable);
                i += variable.length();
            }
            if (remaining.charAt(0) == '(') {
                int nest = 1;
                int chars = 1;
                while (nest > 0) {
                    if (remaining.charAt(chars) == '(') {
                        ++nest;
                    } else if (remaining.charAt(chars) == ')') {
                        --nest;
                    }
                    ++chars;
                }
                parts.add(remaining.substring(0, chars));
                i += chars;
            }
            if (i != iBefore) continue;
            throw new RuntimeException();
        }
        return parts;
    }

    public static Expression<String> parse(String expression) {
        Matcher var = VARIABLE.matcher(expression);
        var.matches();
        if (var.matches()) {
            return Variable.of(var.group(1));
        }
        Matcher truem = TRUE.matcher(expression);
        if (truem.matches()) {
            return Literal.getTrue();
        }
        Matcher falsem = FALSE.matcher(expression);
        if (falsem.matches()) {
            return Literal.getFalse();
        }
        String insideParen = expression.substring(1, expression.length() - 1);
        LinkedList<String> parts = PrefixParser.tokenize(insideParen);
        String part1 = parts.pop();
        ArrayList args = Lists.newArrayList();
        for (String part : parts) {
            args.add(PrefixParser.parse(part));
        }
        if (AND.matcher(part1).matches()) {
            return And.of(args);
        }
        if (OR.matcher(part1).matches()) {
            return Or.of(args);
        }
        if (NOT.matcher(part1).matches()) {
            return Not.of((Expression)args.get(0));
        }
        throw new RuntimeException("no operand found for: " + expression);
    }
}

