/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxEvent;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class EventLog
implements Iterable<BoxEvent> {
    private static final int ENTERPRISE_LIMIT = 500;
    public static final URLTemplate ENTERPRISE_EVENT_URL_TEMPLATE = new URLTemplate("events?stream_type=admin_logs&limit=500");
    private final int chunkSize;
    private final int limit;
    private final String nextStreamPosition;
    private final String streamPosition;
    private final Set<BoxEvent> set;
    private Date startDate;
    private Date endDate;

    EventLog(BoxAPIConnection api, JsonObject json, String streamPosition, int limit) {
        this.streamPosition = streamPosition;
        this.limit = limit;
        this.nextStreamPosition = json.get("next_stream_position").asString();
        this.chunkSize = json.get("chunk_size").asInt();
        this.set = new LinkedHashSet<BoxEvent>(this.chunkSize);
        JsonArray entries = json.get("entries").asArray();
        for (JsonValue entry : entries) {
            this.set.add(new BoxEvent(api, entry.asObject()));
        }
    }

    public static EventLog getEnterpriseEvents(BoxAPIConnection api, String position, Date after, Date before, BoxEvent.Type ... types) {
        return EventLog.getEnterpriseEvents(api, position, after, before, 500, types);
    }

    public static EventLog getEnterpriseEvents(BoxAPIConnection api, Date after, Date before, BoxEvent.Type ... types) {
        return EventLog.getEnterpriseEvents(api, null, after, before, 500, types);
    }

    public static EventLog getEnterpriseEvents(BoxAPIConnection api, String position, Date after, Date before, int limit, BoxEvent.Type ... types) {
        URL url = ENTERPRISE_EVENT_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        if (position != null || types.length > 0 || after != null || before != null || limit != 500) {
            QueryStringBuilder queryBuilder = new QueryStringBuilder(url.getQuery());
            if (after != null) {
                queryBuilder.appendParam("created_after", BoxDateFormat.format(after));
            }
            if (before != null) {
                queryBuilder.appendParam("created_before", BoxDateFormat.format(before));
            }
            if (position != null) {
                queryBuilder.appendParam("stream_position", position);
            }
            if (limit != 500) {
                queryBuilder.appendParam("limit", limit);
            }
            if (types.length > 0) {
                StringBuilder filterBuilder = new StringBuilder();
                for (BoxEvent.Type filterType : types) {
                    filterBuilder.append(filterType.name());
                    filterBuilder.append(',');
                }
                filterBuilder.deleteCharAt(filterBuilder.length() - 1);
                queryBuilder.appendParam("event_type", filterBuilder.toString());
            }
            try {
                url = queryBuilder.addToURL(url);
            }
            catch (MalformedURLException e) {
                throw new BoxAPIException("Couldn't append a query string to the provided URL.");
            }
        }
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        EventLog log = new EventLog(api, responseJSON, position, limit);
        log.setStartDate(after);
        log.setEndDate(before);
        return log;
    }

    void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Iterator<BoxEvent> iterator() {
        return this.set.iterator();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getStreamPosition() {
        return this.streamPosition;
    }

    public String getNextStreamPosition() {
        return this.nextStreamPosition;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getSize() {
        return this.set.size();
    }
}

