/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.zipdownload;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.zipdownload.ZipDownloadNameConflictsField;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class ZipDownload
extends SerializableObject {
    @JsonProperty(value="download_url")
    protected String downloadUrl;
    @JsonProperty(value="status_url")
    protected String statusUrl;
    @JsonProperty(value="expires_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected Date expiresAt;
    @JsonProperty(value="name_conflicts")
    protected List<List<ZipDownloadNameConflictsField>> nameConflicts;

    public ZipDownload() {
    }

    protected ZipDownload(Builder builder) {
        this.downloadUrl = builder.downloadUrl;
        this.statusUrl = builder.statusUrl;
        this.expiresAt = builder.expiresAt;
        this.nameConflicts = builder.nameConflicts;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public List<List<ZipDownloadNameConflictsField>> getNameConflicts() {
        return this.nameConflicts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipDownload casted = (ZipDownload)o;
        return Objects.equals(this.downloadUrl, casted.downloadUrl) && Objects.equals(this.statusUrl, casted.statusUrl) && Objects.equals(this.expiresAt, casted.expiresAt) && Objects.equals(this.nameConflicts, casted.nameConflicts);
    }

    public int hashCode() {
        return Objects.hash(this.downloadUrl, this.statusUrl, this.expiresAt, this.nameConflicts);
    }

    public String toString() {
        return "ZipDownload{downloadUrl='" + this.downloadUrl + '\'' + ", statusUrl='" + this.statusUrl + '\'' + ", expiresAt='" + this.expiresAt + '\'' + ", nameConflicts='" + this.nameConflicts + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String downloadUrl;
        protected String statusUrl;
        protected Date expiresAt;
        protected List<List<ZipDownloadNameConflictsField>> nameConflicts;

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder statusUrl(String statusUrl) {
            this.statusUrl = statusUrl;
            return this;
        }

        public Builder expiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder nameConflicts(List<List<ZipDownloadNameConflictsField>> nameConflicts) {
            this.nameConflicts = nameConflicts;
            return this;
        }

        public ZipDownload build() {
            return new ZipDownload(this);
        }
    }
}

