/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.webhook;

import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.schemas.webhook.WebhookTriggersField;
import com.box.sdkgen.schemas.webhookmini.WebhookMini;
import com.box.sdkgen.schemas.webhookmini.WebhookMiniTargetField;
import com.box.sdkgen.schemas.webhookmini.WebhookMiniTypeField;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.Valuable;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Webhook
extends WebhookMini {
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected Date createdAt;
    protected String address;
    @JsonDeserialize(using=TriggersDeserializer.class)
    @JsonSerialize(using=TriggersSerializer.class)
    protected List<EnumWrapper<WebhookTriggersField>> triggers;

    public Webhook() {
    }

    protected Webhook(Builder builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.address = builder.address;
        this.triggers = builder.triggers;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getAddress() {
        return this.address;
    }

    public List<EnumWrapper<WebhookTriggersField>> getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook casted = (Webhook)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.target, casted.target) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.address, casted.address) && Objects.equals(this.triggers, casted.triggers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.target, this.createdBy, this.createdAt, this.address, this.triggers);
    }

    @Override
    public String toString() {
        return "Webhook{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", target='" + this.target + '\'' + ", createdBy='" + this.createdBy + '\'' + ", createdAt='" + this.createdAt + '\'' + ", address='" + this.address + '\'' + ", triggers='" + this.triggers + '\'' + "}";
    }

    public static class TriggersSerializer
    extends JsonSerializer<List<EnumWrapper<WebhookTriggersField>>> {
        public final JsonSerializer<EnumWrapper<WebhookTriggersField>> elementSerializer = new WebhookTriggersField.WebhookTriggersFieldSerializer();

        public void serialize(List<EnumWrapper<WebhookTriggersField>> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (EnumWrapper<WebhookTriggersField> item : value) {
                this.elementSerializer.serialize(item, gen, serializers);
            }
            gen.writeEndArray();
        }
    }

    public static class TriggersDeserializer
    extends JsonDeserializer<List<EnumWrapper<WebhookTriggersField>>> {
        public final JsonDeserializer<EnumWrapper<WebhookTriggersField>> elementDeserializer = new WebhookTriggersField.WebhookTriggersFieldDeserializer();

        public List<EnumWrapper<WebhookTriggersField>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            ArrayList<EnumWrapper<WebhookTriggersField>> elements = new ArrayList<EnumWrapper<WebhookTriggersField>>();
            for (JsonNode item : node) {
                JsonParser pa = item.traverse(p.getCodec());
                pa.nextToken();
                elements.add((EnumWrapper<WebhookTriggersField>)this.elementDeserializer.deserialize(pa, ctxt));
            }
            return elements;
        }
    }

    public static class Builder
    extends WebhookMini.Builder {
        protected UserMini createdBy;
        protected Date createdAt;
        protected String address;
        protected List<EnumWrapper<WebhookTriggersField>> triggers;

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder triggers(List<? extends Valuable> triggers) {
            this.triggers = EnumWrapper.wrapValuableEnumList(triggers, WebhookTriggersField.class);
            return this;
        }

        @Override
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder type(WebhookMiniTypeField type) {
            this.type = new EnumWrapper<WebhookMiniTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<WebhookMiniTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder target(WebhookMiniTargetField target) {
            this.target = target;
            return this;
        }

        @Override
        public Webhook build() {
            return new Webhook(this);
        }
    }
}

