/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.workflows;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.workflows.GetWorkflowsHeaders;
import com.box.sdkgen.managers.workflows.GetWorkflowsQueryParams;
import com.box.sdkgen.managers.workflows.StartWorkflowHeaders;
import com.box.sdkgen.managers.workflows.StartWorkflowRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.workflows.Workflows;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class WorkflowsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public WorkflowsManager() {
        this.networkSession = new NetworkSession();
    }

    protected WorkflowsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Workflows getWorkflows(GetWorkflowsQueryParams queryParams) {
        return this.getWorkflows(queryParams, new GetWorkflowsHeaders());
    }

    public Workflows getWorkflows(GetWorkflowsQueryParams queryParams, GetWorkflowsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("folder_id", UtilsManager.convertToString(queryParams.getFolderId())), UtilsManager.entryOf("trigger_type", UtilsManager.convertToString(queryParams.getTriggerType())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/workflows"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Workflows.class);
    }

    public void startWorkflow(String workflowId, StartWorkflowRequestBody requestBody) {
        this.startWorkflow(workflowId, requestBody, new StartWorkflowHeaders());
    }

    public void startWorkflow(String workflowId, StartWorkflowRequestBody requestBody, StartWorkflowHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/workflows/", UtilsManager.convertToString(workflowId), "/start"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public WorkflowsManager build() {
            return new WorkflowsManager(this);
        }
    }
}

