/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.trasheditems;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.trasheditems.GetTrashedItemsHeaders;
import com.box.sdkgen.managers.trasheditems.GetTrashedItemsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.items.Items;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TrashedItemsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TrashedItemsManager() {
        this.networkSession = new NetworkSession();
    }

    protected TrashedItemsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Items getTrashedItems() {
        return this.getTrashedItems(new GetTrashedItemsQueryParams(), new GetTrashedItemsHeaders());
    }

    public Items getTrashedItems(GetTrashedItemsQueryParams queryParams) {
        return this.getTrashedItems(queryParams, new GetTrashedItemsHeaders());
    }

    public Items getTrashedItems(GetTrashedItemsHeaders headers) {
        return this.getTrashedItems(new GetTrashedItemsQueryParams(), headers);
    }

    public Items getTrashedItems(GetTrashedItemsQueryParams queryParams, GetTrashedItemsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("usemarker", UtilsManager.convertToString(queryParams.getUsemarker())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("direction", UtilsManager.convertToString(queryParams.getDirection())), UtilsManager.entryOf("sort", UtilsManager.convertToString(queryParams.getSort()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/trash/items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Items.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TrashedItemsManager build() {
            return new TrashedItemsManager(this);
        }
    }
}

