/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.metadatatemplates;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.metadatatemplates.CreateMetadataTemplateHeaders;
import com.box.sdkgen.managers.metadatatemplates.CreateMetadataTemplateRequestBody;
import com.box.sdkgen.managers.metadatatemplates.DeleteMetadataTemplateHeaders;
import com.box.sdkgen.managers.metadatatemplates.DeleteMetadataTemplateScope;
import com.box.sdkgen.managers.metadatatemplates.GetEnterpriseMetadataTemplatesHeaders;
import com.box.sdkgen.managers.metadatatemplates.GetEnterpriseMetadataTemplatesQueryParams;
import com.box.sdkgen.managers.metadatatemplates.GetGlobalMetadataTemplatesHeaders;
import com.box.sdkgen.managers.metadatatemplates.GetGlobalMetadataTemplatesQueryParams;
import com.box.sdkgen.managers.metadatatemplates.GetMetadataTemplateByIdHeaders;
import com.box.sdkgen.managers.metadatatemplates.GetMetadataTemplateHeaders;
import com.box.sdkgen.managers.metadatatemplates.GetMetadataTemplateScope;
import com.box.sdkgen.managers.metadatatemplates.GetMetadataTemplatesByInstanceIdHeaders;
import com.box.sdkgen.managers.metadatatemplates.GetMetadataTemplatesByInstanceIdQueryParams;
import com.box.sdkgen.managers.metadatatemplates.UpdateMetadataTemplateHeaders;
import com.box.sdkgen.managers.metadatatemplates.UpdateMetadataTemplateRequestBody;
import com.box.sdkgen.managers.metadatatemplates.UpdateMetadataTemplateScope;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.metadatatemplate.MetadataTemplate;
import com.box.sdkgen.schemas.metadatatemplates.MetadataTemplates;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.List;
import java.util.Map;

public class MetadataTemplatesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public MetadataTemplatesManager() {
        this.networkSession = new NetworkSession();
    }

    protected MetadataTemplatesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public MetadataTemplates getMetadataTemplatesByInstanceId(GetMetadataTemplatesByInstanceIdQueryParams queryParams) {
        return this.getMetadataTemplatesByInstanceId(queryParams, new GetMetadataTemplatesByInstanceIdHeaders());
    }

    public MetadataTemplates getMetadataTemplatesByInstanceId(GetMetadataTemplatesByInstanceIdQueryParams queryParams, GetMetadataTemplatesByInstanceIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("metadata_instance_id", UtilsManager.convertToString(queryParams.getMetadataInstanceId())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplates.class);
    }

    public MetadataTemplate getMetadataTemplate(GetMetadataTemplateScope scope, String templateKey) {
        return this.getMetadataTemplate(scope, templateKey, new GetMetadataTemplateHeaders());
    }

    public MetadataTemplate getMetadataTemplate(GetMetadataTemplateScope scope, String templateKey, GetMetadataTemplateHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey), "/schema"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplate.class);
    }

    public MetadataTemplate updateMetadataTemplate(UpdateMetadataTemplateScope scope, String templateKey, List<UpdateMetadataTemplateRequestBody> requestBody) {
        return this.updateMetadataTemplate(scope, templateKey, requestBody, new UpdateMetadataTemplateHeaders());
    }

    public MetadataTemplate updateMetadataTemplate(UpdateMetadataTemplateScope scope, String templateKey, List<UpdateMetadataTemplateRequestBody> requestBody, UpdateMetadataTemplateHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey), "/schema"), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json-patch+json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplate.class);
    }

    public void deleteMetadataTemplate(DeleteMetadataTemplateScope scope, String templateKey) {
        this.deleteMetadataTemplate(scope, templateKey, new DeleteMetadataTemplateHeaders());
    }

    public void deleteMetadataTemplate(DeleteMetadataTemplateScope scope, String templateKey, DeleteMetadataTemplateHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey), "/schema"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public MetadataTemplate getMetadataTemplateById(String templateId) {
        return this.getMetadataTemplateById(templateId, new GetMetadataTemplateByIdHeaders());
    }

    public MetadataTemplate getMetadataTemplateById(String templateId, GetMetadataTemplateByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/", UtilsManager.convertToString(templateId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplate.class);
    }

    public MetadataTemplates getGlobalMetadataTemplates() {
        return this.getGlobalMetadataTemplates(new GetGlobalMetadataTemplatesQueryParams(), new GetGlobalMetadataTemplatesHeaders());
    }

    public MetadataTemplates getGlobalMetadataTemplates(GetGlobalMetadataTemplatesQueryParams queryParams) {
        return this.getGlobalMetadataTemplates(queryParams, new GetGlobalMetadataTemplatesHeaders());
    }

    public MetadataTemplates getGlobalMetadataTemplates(GetGlobalMetadataTemplatesHeaders headers) {
        return this.getGlobalMetadataTemplates(new GetGlobalMetadataTemplatesQueryParams(), headers);
    }

    public MetadataTemplates getGlobalMetadataTemplates(GetGlobalMetadataTemplatesQueryParams queryParams, GetGlobalMetadataTemplatesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/global"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplates.class);
    }

    public MetadataTemplates getEnterpriseMetadataTemplates() {
        return this.getEnterpriseMetadataTemplates(new GetEnterpriseMetadataTemplatesQueryParams(), new GetEnterpriseMetadataTemplatesHeaders());
    }

    public MetadataTemplates getEnterpriseMetadataTemplates(GetEnterpriseMetadataTemplatesQueryParams queryParams) {
        return this.getEnterpriseMetadataTemplates(queryParams, new GetEnterpriseMetadataTemplatesHeaders());
    }

    public MetadataTemplates getEnterpriseMetadataTemplates(GetEnterpriseMetadataTemplatesHeaders headers) {
        return this.getEnterpriseMetadataTemplates(new GetEnterpriseMetadataTemplatesQueryParams(), headers);
    }

    public MetadataTemplates getEnterpriseMetadataTemplates(GetEnterpriseMetadataTemplatesQueryParams queryParams, GetEnterpriseMetadataTemplatesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/enterprise"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplates.class);
    }

    public MetadataTemplate createMetadataTemplate(CreateMetadataTemplateRequestBody requestBody) {
        return this.createMetadataTemplate(requestBody, new CreateMetadataTemplateHeaders());
    }

    public MetadataTemplate createMetadataTemplate(CreateMetadataTemplateRequestBody requestBody, CreateMetadataTemplateHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/schema"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTemplate.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public MetadataTemplatesManager build() {
            return new MetadataTemplatesManager(this);
        }
    }
}

