/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.memberships;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.memberships.CreateGroupMembershipHeaders;
import com.box.sdkgen.managers.memberships.CreateGroupMembershipQueryParams;
import com.box.sdkgen.managers.memberships.CreateGroupMembershipRequestBody;
import com.box.sdkgen.managers.memberships.DeleteGroupMembershipByIdHeaders;
import com.box.sdkgen.managers.memberships.GetGroupMembershipByIdHeaders;
import com.box.sdkgen.managers.memberships.GetGroupMembershipByIdQueryParams;
import com.box.sdkgen.managers.memberships.GetGroupMembershipsHeaders;
import com.box.sdkgen.managers.memberships.GetGroupMembershipsQueryParams;
import com.box.sdkgen.managers.memberships.GetUserMembershipsHeaders;
import com.box.sdkgen.managers.memberships.GetUserMembershipsQueryParams;
import com.box.sdkgen.managers.memberships.UpdateGroupMembershipByIdHeaders;
import com.box.sdkgen.managers.memberships.UpdateGroupMembershipByIdQueryParams;
import com.box.sdkgen.managers.memberships.UpdateGroupMembershipByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.groupmembership.GroupMembership;
import com.box.sdkgen.schemas.groupmemberships.GroupMemberships;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class MembershipsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public MembershipsManager() {
        this.networkSession = new NetworkSession();
    }

    protected MembershipsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public GroupMemberships getUserMemberships(String userId) {
        return this.getUserMemberships(userId, new GetUserMembershipsQueryParams(), new GetUserMembershipsHeaders());
    }

    public GroupMemberships getUserMemberships(String userId, GetUserMembershipsQueryParams queryParams) {
        return this.getUserMemberships(userId, queryParams, new GetUserMembershipsHeaders());
    }

    public GroupMemberships getUserMemberships(String userId, GetUserMembershipsHeaders headers) {
        return this.getUserMemberships(userId, new GetUserMembershipsQueryParams(), headers);
    }

    public GroupMemberships getUserMemberships(String userId, GetUserMembershipsQueryParams queryParams, GetUserMembershipsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/memberships"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupMemberships.class);
    }

    public GroupMemberships getGroupMemberships(String groupId) {
        return this.getGroupMemberships(groupId, new GetGroupMembershipsQueryParams(), new GetGroupMembershipsHeaders());
    }

    public GroupMemberships getGroupMemberships(String groupId, GetGroupMembershipsQueryParams queryParams) {
        return this.getGroupMemberships(groupId, queryParams, new GetGroupMembershipsHeaders());
    }

    public GroupMemberships getGroupMemberships(String groupId, GetGroupMembershipsHeaders headers) {
        return this.getGroupMemberships(groupId, new GetGroupMembershipsQueryParams(), headers);
    }

    public GroupMemberships getGroupMemberships(String groupId, GetGroupMembershipsQueryParams queryParams, GetGroupMembershipsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/", UtilsManager.convertToString(groupId), "/memberships"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupMemberships.class);
    }

    public GroupMembership createGroupMembership(CreateGroupMembershipRequestBody requestBody) {
        return this.createGroupMembership(requestBody, new CreateGroupMembershipQueryParams(), new CreateGroupMembershipHeaders());
    }

    public GroupMembership createGroupMembership(CreateGroupMembershipRequestBody requestBody, CreateGroupMembershipQueryParams queryParams) {
        return this.createGroupMembership(requestBody, queryParams, new CreateGroupMembershipHeaders());
    }

    public GroupMembership createGroupMembership(CreateGroupMembershipRequestBody requestBody, CreateGroupMembershipHeaders headers) {
        return this.createGroupMembership(requestBody, new CreateGroupMembershipQueryParams(), headers);
    }

    public GroupMembership createGroupMembership(CreateGroupMembershipRequestBody requestBody, CreateGroupMembershipQueryParams queryParams, CreateGroupMembershipHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/group_memberships"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupMembership.class);
    }

    public GroupMembership getGroupMembershipById(String groupMembershipId) {
        return this.getGroupMembershipById(groupMembershipId, new GetGroupMembershipByIdQueryParams(), new GetGroupMembershipByIdHeaders());
    }

    public GroupMembership getGroupMembershipById(String groupMembershipId, GetGroupMembershipByIdQueryParams queryParams) {
        return this.getGroupMembershipById(groupMembershipId, queryParams, new GetGroupMembershipByIdHeaders());
    }

    public GroupMembership getGroupMembershipById(String groupMembershipId, GetGroupMembershipByIdHeaders headers) {
        return this.getGroupMembershipById(groupMembershipId, new GetGroupMembershipByIdQueryParams(), headers);
    }

    public GroupMembership getGroupMembershipById(String groupMembershipId, GetGroupMembershipByIdQueryParams queryParams, GetGroupMembershipByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/group_memberships/", UtilsManager.convertToString(groupMembershipId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupMembership.class);
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId) {
        return this.updateGroupMembershipById(groupMembershipId, new UpdateGroupMembershipByIdRequestBody(), new UpdateGroupMembershipByIdQueryParams(), new UpdateGroupMembershipByIdHeaders());
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdRequestBody requestBody) {
        return this.updateGroupMembershipById(groupMembershipId, requestBody, new UpdateGroupMembershipByIdQueryParams(), new UpdateGroupMembershipByIdHeaders());
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdQueryParams queryParams) {
        return this.updateGroupMembershipById(groupMembershipId, new UpdateGroupMembershipByIdRequestBody(), queryParams, new UpdateGroupMembershipByIdHeaders());
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdRequestBody requestBody, UpdateGroupMembershipByIdQueryParams queryParams) {
        return this.updateGroupMembershipById(groupMembershipId, requestBody, queryParams, new UpdateGroupMembershipByIdHeaders());
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdHeaders headers) {
        return this.updateGroupMembershipById(groupMembershipId, new UpdateGroupMembershipByIdRequestBody(), new UpdateGroupMembershipByIdQueryParams(), headers);
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdRequestBody requestBody, UpdateGroupMembershipByIdHeaders headers) {
        return this.updateGroupMembershipById(groupMembershipId, requestBody, new UpdateGroupMembershipByIdQueryParams(), headers);
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdQueryParams queryParams, UpdateGroupMembershipByIdHeaders headers) {
        return this.updateGroupMembershipById(groupMembershipId, new UpdateGroupMembershipByIdRequestBody(), queryParams, headers);
    }

    public GroupMembership updateGroupMembershipById(String groupMembershipId, UpdateGroupMembershipByIdRequestBody requestBody, UpdateGroupMembershipByIdQueryParams queryParams, UpdateGroupMembershipByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/group_memberships/", UtilsManager.convertToString(groupMembershipId)), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), GroupMembership.class);
    }

    public void deleteGroupMembershipById(String groupMembershipId) {
        this.deleteGroupMembershipById(groupMembershipId, new DeleteGroupMembershipByIdHeaders());
    }

    public void deleteGroupMembershipById(String groupMembershipId, DeleteGroupMembershipByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/group_memberships/", UtilsManager.convertToString(groupMembershipId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public MembershipsManager build() {
            return new MembershipsManager(this);
        }
    }
}

