/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.hubitems;

import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.hubitems.GetHubItemsV2025R0Headers;
import com.box.sdkgen.managers.hubitems.GetHubItemsV2025R0QueryParams;
import com.box.sdkgen.managers.hubitems.ManageHubItemsV2025R0Headers;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.v2025r0.hubitemsmanagerequestv2025r0.HubItemsManageRequestV2025R0;
import com.box.sdkgen.schemas.v2025r0.hubitemsmanageresponsev2025r0.HubItemsManageResponseV2025R0;
import com.box.sdkgen.schemas.v2025r0.hubitemsv2025r0.HubItemsV2025R0;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class HubItemsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public HubItemsManager() {
        this.networkSession = new NetworkSession();
    }

    protected HubItemsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public HubItemsV2025R0 getHubItemsV2025R0(GetHubItemsV2025R0QueryParams queryParams) {
        return this.getHubItemsV2025R0(queryParams, new GetHubItemsV2025R0Headers());
    }

    public HubItemsV2025R0 getHubItemsV2025R0(GetHubItemsV2025R0QueryParams queryParams, GetHubItemsV2025R0Headers headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("hub_id", UtilsManager.convertToString(queryParams.getHubId())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/hub_items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), HubItemsV2025R0.class);
    }

    public HubItemsManageResponseV2025R0 manageHubItemsV2025R0(String hubId, HubItemsManageRequestV2025R0 requestBody) {
        return this.manageHubItemsV2025R0(hubId, requestBody, new ManageHubItemsV2025R0Headers());
    }

    public HubItemsManageResponseV2025R0 manageHubItemsV2025R0(String hubId, HubItemsManageRequestV2025R0 requestBody, ManageHubItemsV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/hubs/", UtilsManager.convertToString(hubId), "/manage_items"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), HubItemsManageResponseV2025R0.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public HubItemsManager build() {
            return new HubItemsManager(this);
        }
    }
}

