/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.folders;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.folders.CopyFolderHeaders;
import com.box.sdkgen.managers.folders.CopyFolderQueryParams;
import com.box.sdkgen.managers.folders.CopyFolderRequestBody;
import com.box.sdkgen.managers.folders.CreateFolderHeaders;
import com.box.sdkgen.managers.folders.CreateFolderQueryParams;
import com.box.sdkgen.managers.folders.CreateFolderRequestBody;
import com.box.sdkgen.managers.folders.DeleteFolderByIdHeaders;
import com.box.sdkgen.managers.folders.DeleteFolderByIdQueryParams;
import com.box.sdkgen.managers.folders.GetFolderByIdHeaders;
import com.box.sdkgen.managers.folders.GetFolderByIdQueryParams;
import com.box.sdkgen.managers.folders.GetFolderItemsHeaders;
import com.box.sdkgen.managers.folders.GetFolderItemsQueryParams;
import com.box.sdkgen.managers.folders.UpdateFolderByIdHeaders;
import com.box.sdkgen.managers.folders.UpdateFolderByIdQueryParams;
import com.box.sdkgen.managers.folders.UpdateFolderByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.folderfull.FolderFull;
import com.box.sdkgen.schemas.items.Items;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class FoldersManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FoldersManager() {
        this.networkSession = new NetworkSession();
    }

    protected FoldersManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FolderFull getFolderById(String folderId) {
        return this.getFolderById(folderId, new GetFolderByIdQueryParams(), new GetFolderByIdHeaders());
    }

    public FolderFull getFolderById(String folderId, GetFolderByIdQueryParams queryParams) {
        return this.getFolderById(folderId, queryParams, new GetFolderByIdHeaders());
    }

    public FolderFull getFolderById(String folderId, GetFolderByIdHeaders headers) {
        return this.getFolderById(folderId, new GetFolderByIdQueryParams(), headers);
    }

    public FolderFull getFolderById(String folderId, GetFolderByIdQueryParams queryParams, GetFolderByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("sort", UtilsManager.convertToString(queryParams.getSort())), UtilsManager.entryOf("direction", UtilsManager.convertToString(queryParams.getDirection())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch())), UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull updateFolderById(String folderId) {
        return this.updateFolderById(folderId, new UpdateFolderByIdRequestBody(), new UpdateFolderByIdQueryParams(), new UpdateFolderByIdHeaders());
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdRequestBody requestBody) {
        return this.updateFolderById(folderId, requestBody, new UpdateFolderByIdQueryParams(), new UpdateFolderByIdHeaders());
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdQueryParams queryParams) {
        return this.updateFolderById(folderId, new UpdateFolderByIdRequestBody(), queryParams, new UpdateFolderByIdHeaders());
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdRequestBody requestBody, UpdateFolderByIdQueryParams queryParams) {
        return this.updateFolderById(folderId, requestBody, queryParams, new UpdateFolderByIdHeaders());
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdHeaders headers) {
        return this.updateFolderById(folderId, new UpdateFolderByIdRequestBody(), new UpdateFolderByIdQueryParams(), headers);
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdRequestBody requestBody, UpdateFolderByIdHeaders headers) {
        return this.updateFolderById(folderId, requestBody, new UpdateFolderByIdQueryParams(), headers);
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdQueryParams queryParams, UpdateFolderByIdHeaders headers) {
        return this.updateFolderById(folderId, new UpdateFolderByIdRequestBody(), queryParams, headers);
    }

    public FolderFull updateFolderById(String folderId, UpdateFolderByIdRequestBody requestBody, UpdateFolderByIdQueryParams queryParams, UpdateFolderByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId)), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public void deleteFolderById(String folderId) {
        this.deleteFolderById(folderId, new DeleteFolderByIdQueryParams(), new DeleteFolderByIdHeaders());
    }

    public void deleteFolderById(String folderId, DeleteFolderByIdQueryParams queryParams) {
        this.deleteFolderById(folderId, queryParams, new DeleteFolderByIdHeaders());
    }

    public void deleteFolderById(String folderId, DeleteFolderByIdHeaders headers) {
        this.deleteFolderById(folderId, new DeleteFolderByIdQueryParams(), headers);
    }

    public void deleteFolderById(String folderId, DeleteFolderByIdQueryParams queryParams, DeleteFolderByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("recursive", UtilsManager.convertToString(queryParams.getRecursive()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId)), "DELETE").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Items getFolderItems(String folderId) {
        return this.getFolderItems(folderId, new GetFolderItemsQueryParams(), new GetFolderItemsHeaders());
    }

    public Items getFolderItems(String folderId, GetFolderItemsQueryParams queryParams) {
        return this.getFolderItems(folderId, queryParams, new GetFolderItemsHeaders());
    }

    public Items getFolderItems(String folderId, GetFolderItemsHeaders headers) {
        return this.getFolderItems(folderId, new GetFolderItemsQueryParams(), headers);
    }

    public Items getFolderItems(String folderId, GetFolderItemsQueryParams queryParams, GetFolderItemsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("usemarker", UtilsManager.convertToString(queryParams.getUsemarker())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("sort", UtilsManager.convertToString(queryParams.getSort())), UtilsManager.entryOf("direction", UtilsManager.convertToString(queryParams.getDirection()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Items.class);
    }

    public FolderFull createFolder(CreateFolderRequestBody requestBody) {
        return this.createFolder(requestBody, new CreateFolderQueryParams(), new CreateFolderHeaders());
    }

    public FolderFull createFolder(CreateFolderRequestBody requestBody, CreateFolderQueryParams queryParams) {
        return this.createFolder(requestBody, queryParams, new CreateFolderHeaders());
    }

    public FolderFull createFolder(CreateFolderRequestBody requestBody, CreateFolderHeaders headers) {
        return this.createFolder(requestBody, new CreateFolderQueryParams(), headers);
    }

    public FolderFull createFolder(CreateFolderRequestBody requestBody, CreateFolderQueryParams queryParams, CreateFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull copyFolder(String folderId, CopyFolderRequestBody requestBody) {
        return this.copyFolder(folderId, requestBody, new CopyFolderQueryParams(), new CopyFolderHeaders());
    }

    public FolderFull copyFolder(String folderId, CopyFolderRequestBody requestBody, CopyFolderQueryParams queryParams) {
        return this.copyFolder(folderId, requestBody, queryParams, new CopyFolderHeaders());
    }

    public FolderFull copyFolder(String folderId, CopyFolderRequestBody requestBody, CopyFolderHeaders headers) {
        return this.copyFolder(folderId, requestBody, new CopyFolderQueryParams(), headers);
    }

    public FolderFull copyFolder(String folderId, CopyFolderRequestBody requestBody, CopyFolderQueryParams queryParams, CopyFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/copy"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FoldersManager build() {
            return new FoldersManager(this);
        }
    }
}

