/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.fileversionretentions;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.fileversionretentions.GetFileVersionRetentionByIdHeaders;
import com.box.sdkgen.managers.fileversionretentions.GetFileVersionRetentionsHeaders;
import com.box.sdkgen.managers.fileversionretentions.GetFileVersionRetentionsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.fileversionretention.FileVersionRetention;
import com.box.sdkgen.schemas.fileversionretentions.FileVersionRetentions;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class FileVersionRetentionsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FileVersionRetentionsManager() {
        this.networkSession = new NetworkSession();
    }

    protected FileVersionRetentionsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FileVersionRetentions getFileVersionRetentions() {
        return this.getFileVersionRetentions(new GetFileVersionRetentionsQueryParams(), new GetFileVersionRetentionsHeaders());
    }

    public FileVersionRetentions getFileVersionRetentions(GetFileVersionRetentionsQueryParams queryParams) {
        return this.getFileVersionRetentions(queryParams, new GetFileVersionRetentionsHeaders());
    }

    public FileVersionRetentions getFileVersionRetentions(GetFileVersionRetentionsHeaders headers) {
        return this.getFileVersionRetentions(new GetFileVersionRetentionsQueryParams(), headers);
    }

    public FileVersionRetentions getFileVersionRetentions(GetFileVersionRetentionsQueryParams queryParams, GetFileVersionRetentionsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("file_id", UtilsManager.convertToString(queryParams.getFileId())), UtilsManager.entryOf("file_version_id", UtilsManager.convertToString(queryParams.getFileVersionId())), UtilsManager.entryOf("policy_id", UtilsManager.convertToString(queryParams.getPolicyId())), UtilsManager.entryOf("disposition_action", UtilsManager.convertToString(queryParams.getDispositionAction())), UtilsManager.entryOf("disposition_before", UtilsManager.convertToString(queryParams.getDispositionBefore())), UtilsManager.entryOf("disposition_after", UtilsManager.convertToString(queryParams.getDispositionAfter())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/file_version_retentions"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileVersionRetentions.class);
    }

    public FileVersionRetention getFileVersionRetentionById(String fileVersionRetentionId) {
        return this.getFileVersionRetentionById(fileVersionRetentionId, new GetFileVersionRetentionByIdHeaders());
    }

    public FileVersionRetention getFileVersionRetentionById(String fileVersionRetentionId, GetFileVersionRetentionByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/file_version_retentions/", UtilsManager.convertToString(fileVersionRetentionId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileVersionRetention.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FileVersionRetentionsManager build() {
            return new FileVersionRetentionsManager(this);
        }
    }
}

