/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.collaborationallowlistentries;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.collaborationallowlistentries.CreateCollaborationWhitelistEntryHeaders;
import com.box.sdkgen.managers.collaborationallowlistentries.CreateCollaborationWhitelistEntryRequestBody;
import com.box.sdkgen.managers.collaborationallowlistentries.DeleteCollaborationWhitelistEntryByIdHeaders;
import com.box.sdkgen.managers.collaborationallowlistentries.GetCollaborationWhitelistEntriesHeaders;
import com.box.sdkgen.managers.collaborationallowlistentries.GetCollaborationWhitelistEntriesQueryParams;
import com.box.sdkgen.managers.collaborationallowlistentries.GetCollaborationWhitelistEntryByIdHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.collaborationallowlistentries.CollaborationAllowlistEntries;
import com.box.sdkgen.schemas.collaborationallowlistentry.CollaborationAllowlistEntry;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class CollaborationAllowlistEntriesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public CollaborationAllowlistEntriesManager() {
        this.networkSession = new NetworkSession();
    }

    protected CollaborationAllowlistEntriesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public CollaborationAllowlistEntries getCollaborationWhitelistEntries() {
        return this.getCollaborationWhitelistEntries(new GetCollaborationWhitelistEntriesQueryParams(), new GetCollaborationWhitelistEntriesHeaders());
    }

    public CollaborationAllowlistEntries getCollaborationWhitelistEntries(GetCollaborationWhitelistEntriesQueryParams queryParams) {
        return this.getCollaborationWhitelistEntries(queryParams, new GetCollaborationWhitelistEntriesHeaders());
    }

    public CollaborationAllowlistEntries getCollaborationWhitelistEntries(GetCollaborationWhitelistEntriesHeaders headers) {
        return this.getCollaborationWhitelistEntries(new GetCollaborationWhitelistEntriesQueryParams(), headers);
    }

    public CollaborationAllowlistEntries getCollaborationWhitelistEntries(GetCollaborationWhitelistEntriesQueryParams queryParams, GetCollaborationWhitelistEntriesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaboration_whitelist_entries"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), CollaborationAllowlistEntries.class);
    }

    public CollaborationAllowlistEntry createCollaborationWhitelistEntry(CreateCollaborationWhitelistEntryRequestBody requestBody) {
        return this.createCollaborationWhitelistEntry(requestBody, new CreateCollaborationWhitelistEntryHeaders());
    }

    public CollaborationAllowlistEntry createCollaborationWhitelistEntry(CreateCollaborationWhitelistEntryRequestBody requestBody, CreateCollaborationWhitelistEntryHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaboration_whitelist_entries"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), CollaborationAllowlistEntry.class);
    }

    public CollaborationAllowlistEntry getCollaborationWhitelistEntryById(String collaborationWhitelistEntryId) {
        return this.getCollaborationWhitelistEntryById(collaborationWhitelistEntryId, new GetCollaborationWhitelistEntryByIdHeaders());
    }

    public CollaborationAllowlistEntry getCollaborationWhitelistEntryById(String collaborationWhitelistEntryId, GetCollaborationWhitelistEntryByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaboration_whitelist_entries/", UtilsManager.convertToString(collaborationWhitelistEntryId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), CollaborationAllowlistEntry.class);
    }

    public void deleteCollaborationWhitelistEntryById(String collaborationWhitelistEntryId) {
        this.deleteCollaborationWhitelistEntryById(collaborationWhitelistEntryId, new DeleteCollaborationWhitelistEntryByIdHeaders());
    }

    public void deleteCollaborationWhitelistEntryById(String collaborationWhitelistEntryId, DeleteCollaborationWhitelistEntryByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaboration_whitelist_entries/", UtilsManager.convertToString(collaborationWhitelistEntryId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public CollaborationAllowlistEntriesManager build() {
            return new CollaborationAllowlistEntriesManager(this);
        }
    }
}

