/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.aistudio;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.aistudio.CreateAiAgentHeaders;
import com.box.sdkgen.managers.aistudio.DeleteAiAgentByIdHeaders;
import com.box.sdkgen.managers.aistudio.GetAiAgentByIdHeaders;
import com.box.sdkgen.managers.aistudio.GetAiAgentByIdQueryParams;
import com.box.sdkgen.managers.aistudio.GetAiAgentsHeaders;
import com.box.sdkgen.managers.aistudio.GetAiAgentsQueryParams;
import com.box.sdkgen.managers.aistudio.UpdateAiAgentByIdHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.aimultipleagentresponse.AiMultipleAgentResponse;
import com.box.sdkgen.schemas.aisingleagentresponsefull.AiSingleAgentResponseFull;
import com.box.sdkgen.schemas.createaiagent.CreateAiAgent;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class AiStudioManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public AiStudioManager() {
        this.networkSession = new NetworkSession();
    }

    protected AiStudioManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public AiMultipleAgentResponse getAiAgents() {
        return this.getAiAgents(new GetAiAgentsQueryParams(), new GetAiAgentsHeaders());
    }

    public AiMultipleAgentResponse getAiAgents(GetAiAgentsQueryParams queryParams) {
        return this.getAiAgents(queryParams, new GetAiAgentsHeaders());
    }

    public AiMultipleAgentResponse getAiAgents(GetAiAgentsHeaders headers) {
        return this.getAiAgents(new GetAiAgentsQueryParams(), headers);
    }

    public AiMultipleAgentResponse getAiAgents(GetAiAgentsQueryParams queryParams, GetAiAgentsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("mode", UtilsManager.convertToString(queryParams.getMode())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("agent_state", UtilsManager.convertToString(queryParams.getAgentState())), UtilsManager.entryOf("include_box_default", UtilsManager.convertToString(queryParams.getIncludeBoxDefault())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agents"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiMultipleAgentResponse.class);
    }

    public AiSingleAgentResponseFull createAiAgent(CreateAiAgent requestBody) {
        return this.createAiAgent(requestBody, new CreateAiAgentHeaders());
    }

    public AiSingleAgentResponseFull createAiAgent(CreateAiAgent requestBody, CreateAiAgentHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agents"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiSingleAgentResponseFull.class);
    }

    public AiSingleAgentResponseFull updateAiAgentById(String agentId, CreateAiAgent requestBody) {
        return this.updateAiAgentById(agentId, requestBody, new UpdateAiAgentByIdHeaders());
    }

    public AiSingleAgentResponseFull updateAiAgentById(String agentId, CreateAiAgent requestBody, UpdateAiAgentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agents/", UtilsManager.convertToString(agentId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiSingleAgentResponseFull.class);
    }

    public AiSingleAgentResponseFull getAiAgentById(String agentId) {
        return this.getAiAgentById(agentId, new GetAiAgentByIdQueryParams(), new GetAiAgentByIdHeaders());
    }

    public AiSingleAgentResponseFull getAiAgentById(String agentId, GetAiAgentByIdQueryParams queryParams) {
        return this.getAiAgentById(agentId, queryParams, new GetAiAgentByIdHeaders());
    }

    public AiSingleAgentResponseFull getAiAgentById(String agentId, GetAiAgentByIdHeaders headers) {
        return this.getAiAgentById(agentId, new GetAiAgentByIdQueryParams(), headers);
    }

    public AiSingleAgentResponseFull getAiAgentById(String agentId, GetAiAgentByIdQueryParams queryParams, GetAiAgentByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agents/", UtilsManager.convertToString(agentId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiSingleAgentResponseFull.class);
    }

    public void deleteAiAgentById(String agentId) {
        this.deleteAiAgentById(agentId, new DeleteAiAgentByIdHeaders());
    }

    public void deleteAiAgentById(String agentId, DeleteAiAgentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agents/", UtilsManager.convertToString(agentId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public AiStudioManager build() {
            return new AiStudioManager(this);
        }
    }
}

