package com.box.sdkgen.managers.termsofservices;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class CreateTermsOfServiceHeaders {

  public Map<String, String> extraHeaders;

  public CreateTermsOfServiceHeaders() {
    this.extraHeaders = mapOf();
  }

  protected CreateTermsOfServiceHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public CreateTermsOfServiceHeaders build() {
      return new CreateTermsOfServiceHeaders(this);
    }
  }
}
