package com.box.sdkgen.managers.signrequests;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class CancelSignRequestHeaders {

  public Map<String, String> extraHeaders;

  public CancelSignRequestHeaders() {
    this.extraHeaders = mapOf();
  }

  protected CancelSignRequestHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public CancelSignRequestHeaders build() {
      return new CancelSignRequestHeaders(this);
    }
  }
}
