package com.box.sdkgen.managers.folderwatermarks;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class UpdateFolderWatermarkHeaders {

  public Map<String, String> extraHeaders;

  public UpdateFolderWatermarkHeaders() {
    this.extraHeaders = mapOf();
  }

  protected UpdateFolderWatermarkHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public UpdateFolderWatermarkHeaders build() {
      return new UpdateFolderWatermarkHeaders(this);
    }
  }
}
