package com.box.sdkgen.managers.fileversions;

import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.Valuable;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;

public enum PromoteFileVersionRequestBodyTypeField implements Valuable {
  FILE_VERSION("file_version");

  private final String value;

  PromoteFileVersionRequestBodyTypeField(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  public static class PromoteFileVersionRequestBodyTypeFieldDeserializer
      extends JsonDeserializer<EnumWrapper<PromoteFileVersionRequestBodyTypeField>> {

    public PromoteFileVersionRequestBodyTypeFieldDeserializer() {
      super();
    }

    @Override
    public EnumWrapper<PromoteFileVersionRequestBodyTypeField> deserialize(
        JsonParser p, DeserializationContext ctxt) throws IOException {
      String value = p.getValueAsString();
      return Arrays.stream(PromoteFileVersionRequestBodyTypeField.values())
          .filter((v) -> v.getValue().equalsIgnoreCase(value))
          .findFirst()
          .map(EnumWrapper::new)
          .orElse(new EnumWrapper<PromoteFileVersionRequestBodyTypeField>(value));
    }
  }

  public static class PromoteFileVersionRequestBodyTypeFieldSerializer
      extends JsonSerializer<EnumWrapper<PromoteFileVersionRequestBodyTypeField>> {

    public PromoteFileVersionRequestBodyTypeFieldSerializer() {
      super();
    }

    @Override
    public void serialize(
        EnumWrapper<PromoteFileVersionRequestBodyTypeField> value,
        JsonGenerator gen,
        SerializerProvider serializers)
        throws IOException {
      gen.writeString(value.getStringValue());
    }
  }
}
