/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.engines.XSalsa20Engine;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XSalsa20 {
    private XSalsa20() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new XSalsa20Engine(), 24);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XSalsa20", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XSalsa20.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.XSALSA20", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.XSALSA20", PREFIX + "$KeyGen");
        }
    }
}

